/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.hasher;

import com.password4j.BcryptFunction;
import com.password4j.HashingFunction;
import com.password4j.Password;
import com.password4j.types.Bcrypt;
import java.nio.CharBuffer;
import org.opensearch.security.hasher.AbstractPasswordHasher;

class BCryptPasswordHasher
extends AbstractPasswordHasher {
    BCryptPasswordHasher(String minor, int logRounds) {
        this.hashingFunction = BcryptFunction.getInstance((Bcrypt)Bcrypt.valueOf((String)minor), (int)logRounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hash(char[] password) {
        this.checkPasswordNotNullOrEmpty(password);
        CharBuffer passwordBuffer = CharBuffer.wrap(password);
        try {
            String string = Password.hash((CharSequence)passwordBuffer).with(this.hashingFunction).getResult();
            return string;
        }
        finally {
            this.cleanup(passwordBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(char[] password, String hash) {
        this.checkPasswordNotNullOrEmpty(password);
        this.checkHashNotNullOrEmpty(hash);
        CharBuffer passwordBuffer = CharBuffer.wrap(password);
        try {
            boolean bl = Password.check((CharSequence)passwordBuffer, (String)hash).with(this.getBCryptFunctionFromHash(hash));
            return bl;
        }
        finally {
            this.cleanup(passwordBuffer);
        }
    }

    private HashingFunction getBCryptFunctionFromHash(String hash) {
        return BcryptFunction.getInstanceFromHash((String)hash);
    }
}

