/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.support;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.shard.SearchOperationListener;
import org.opensearch.search.internal.ReaderContext;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.transport.TransportRequest;

public interface GuardedSearchOperationWrapper {
    public static final Logger log = LogManager.getLogger(GuardedSearchOperationWrapper.class);

    public void onPreQueryPhase(SearchContext var1);

    public void onNewReaderContext(ReaderContext var1);

    public void onNewScrollContext(ReaderContext var1);

    public void validateReaderContext(ReaderContext var1, TransportRequest var2);

    public void onQueryPhase(SearchContext var1, long var2);

    default public SearchOperationListener toListener() {
        return new InnerSearchOperationListener(this);
    }

    public static class InnerSearchOperationListener
    implements SearchOperationListener {
        private GuardedSearchOperationWrapper that;

        InnerSearchOperationListener(GuardedSearchOperationWrapper that) {
            this.that = that;
        }

        public void onPreQueryPhase(SearchContext searchContext) {
            try {
                this.that.onPreQueryPhase(searchContext);
            }
            catch (Exception e) {
                searchContext.setTask(null);
                log.error("Cancelled request due to internal error", (Throwable)e);
            }
        }

        public void onNewReaderContext(ReaderContext readerContext) {
            this.that.onNewReaderContext(readerContext);
        }

        public void onNewScrollContext(ReaderContext readerContext) {
            this.that.onNewScrollContext(readerContext);
        }

        public void validateReaderContext(ReaderContext readerContext, TransportRequest transportRequest) {
            this.that.validateReaderContext(readerContext, transportRequest);
        }

        public void onQueryPhase(SearchContext searchContext, long tookInNanos) {
            try {
                this.that.onQueryPhase(searchContext, tookInNanos);
            }
            catch (Exception e) {
                searchContext.setTask(null);
                log.error("Cancelled request due to internal error", (Throwable)e);
            }
        }
    }
}

