/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.util;

import org.apache.lucene.search.BooleanClause;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilderVisitor;
import org.opensearch.join.query.HasChildQueryBuilder;
import org.opensearch.join.query.HasParentQueryBuilder;

public final class ParentChildrenQueryDetector
implements QueryBuilderVisitor {
    private boolean queryPresent = false;

    private ParentChildrenQueryDetector() {
    }

    public static boolean hasParentOrChildQuery(QueryBuilder queryBuilder) {
        ParentChildrenQueryDetector detector = new ParentChildrenQueryDetector();
        queryBuilder.visit((QueryBuilderVisitor)detector);
        return detector.hasParentOrChildQuery();
    }

    public void accept(QueryBuilder queryBuilder) {
        if (queryBuilder instanceof HasParentQueryBuilder || queryBuilder instanceof HasChildQueryBuilder) {
            this.queryPresent = true;
        }
    }

    public QueryBuilderVisitor getChildVisitor(BooleanClause.Occur occur) {
        return this;
    }

    public boolean hasParentOrChildQuery() {
        return this.queryPresent;
    }
}

