/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.indices;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.opensearch.client.indices.IndexTemplateMetadata;
import org.opensearch.core.xcontent.XContentParser;

public class GetIndexTemplatesResponse {
    private final List<IndexTemplateMetadata> indexTemplates;

    public String toString() {
        ArrayList<IndexTemplateMetadata> thisList = new ArrayList<IndexTemplateMetadata>(this.indexTemplates);
        thisList.sort(Comparator.comparing(IndexTemplateMetadata::name));
        return "GetIndexTemplatesResponse [indexTemplates=" + String.valueOf(thisList) + "]";
    }

    GetIndexTemplatesResponse() {
        this.indexTemplates = new ArrayList<IndexTemplateMetadata>();
    }

    GetIndexTemplatesResponse(List<IndexTemplateMetadata> indexTemplates) {
        this.indexTemplates = indexTemplates;
    }

    public List<IndexTemplateMetadata> getIndexTemplates() {
        return this.indexTemplates;
    }

    public static GetIndexTemplatesResponse fromXContent(XContentParser parser) throws IOException {
        ArrayList<IndexTemplateMetadata> templates = new ArrayList<IndexTemplateMetadata>();
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                IndexTemplateMetadata templateMetadata = IndexTemplateMetadata.Builder.fromXContent(parser, parser.currentName());
                templates.add(templateMetadata);
            }
            token = parser.nextToken();
        }
        return new GetIndexTemplatesResponse(templates);
    }

    public int hashCode() {
        ArrayList<IndexTemplateMetadata> sortedList = new ArrayList<IndexTemplateMetadata>(this.indexTemplates);
        sortedList.sort(Comparator.comparing(IndexTemplateMetadata::name));
        return Objects.hash(sortedList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetIndexTemplatesResponse other = (GetIndexTemplatesResponse)obj;
        ArrayList<IndexTemplateMetadata> thisList = new ArrayList<IndexTemplateMetadata>(this.indexTemplates);
        ArrayList<IndexTemplateMetadata> otherList = new ArrayList<IndexTemplateMetadata>(other.indexTemplates);
        thisList.sort(Comparator.comparing(IndexTemplateMetadata::name));
        otherList.sort(Comparator.comparing(IndexTemplateMetadata::name));
        return Objects.equals(thisList, otherList);
    }
}

