/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ConsumerGroupHeartbeatRequestData
implements ApiMessage {
    String groupId;
    String memberId;
    int memberEpoch;
    String instanceId;
    String rackId;
    int rebalanceTimeoutMs;
    List<String> subscribedTopicNames;
    String subscribedTopicRegex;
    String serverAssignor;
    List<TopicPartitions> topicPartitions;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("group_id", Type.COMPACT_STRING, "The group identifier."), new Field("member_id", Type.COMPACT_STRING, "The member id generated by the consumer. The member id must be kept during the entire lifetime of the consumer process."), new Field("member_epoch", Type.INT32, "The current member epoch; 0 to join the group; -1 to leave the group; -2 to indicate that the static member will rejoin."), new Field("instance_id", Type.COMPACT_NULLABLE_STRING, "null if not provided or if it didn't change since the last heartbeat; the instance Id otherwise."), new Field("rack_id", Type.COMPACT_NULLABLE_STRING, "null if not provided or if it didn't change since the last heartbeat; the rack ID of consumer otherwise."), new Field("rebalance_timeout_ms", Type.INT32, "-1 if it didn't change since the last heartbeat; the maximum time in milliseconds that the coordinator will wait on the member to revoke its partitions otherwise."), new Field("subscribed_topic_names", CompactArrayOf.nullable(Type.COMPACT_STRING), "null if it didn't change since the last heartbeat; the subscribed topic names otherwise."), new Field("server_assignor", Type.COMPACT_NULLABLE_STRING, "null if not used or if it didn't change since the last heartbeat; the server side assignor to use otherwise."), new Field("topic_partitions", CompactArrayOf.nullable(TopicPartitions.SCHEMA_0), "null if it didn't change since the last heartbeat; the partitions owned by the member."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("group_id", Type.COMPACT_STRING, "The group identifier."), new Field("member_id", Type.COMPACT_STRING, "The member id generated by the consumer. The member id must be kept during the entire lifetime of the consumer process."), new Field("member_epoch", Type.INT32, "The current member epoch; 0 to join the group; -1 to leave the group; -2 to indicate that the static member will rejoin."), new Field("instance_id", Type.COMPACT_NULLABLE_STRING, "null if not provided or if it didn't change since the last heartbeat; the instance Id otherwise."), new Field("rack_id", Type.COMPACT_NULLABLE_STRING, "null if not provided or if it didn't change since the last heartbeat; the rack ID of consumer otherwise."), new Field("rebalance_timeout_ms", Type.INT32, "-1 if it didn't change since the last heartbeat; the maximum time in milliseconds that the coordinator will wait on the member to revoke its partitions otherwise."), new Field("subscribed_topic_names", CompactArrayOf.nullable(Type.COMPACT_STRING), "null if it didn't change since the last heartbeat; the subscribed topic names otherwise."), new Field("subscribed_topic_regex", Type.COMPACT_NULLABLE_STRING, "null if it didn't change since the last heartbeat; the subscribed topic regex otherwise."), new Field("server_assignor", Type.COMPACT_NULLABLE_STRING, "null if not used or if it didn't change since the last heartbeat; the server side assignor to use otherwise."), new Field("topic_partitions", CompactArrayOf.nullable(TopicPartitions.SCHEMA_0), "null if it didn't change since the last heartbeat; the partitions owned by the member."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public ConsumerGroupHeartbeatRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ConsumerGroupHeartbeatRequestData() {
        this.groupId = "";
        this.memberId = "";
        this.memberEpoch = 0;
        this.instanceId = null;
        this.rackId = null;
        this.rebalanceTimeoutMs = -1;
        this.subscribedTopicNames = null;
        this.subscribedTopicRegex = null;
        this.serverAssignor = null;
        this.topicPartitions = null;
    }

    @Override
    public short apiKey() {
        return 68;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        int i;
        ArrayList<String> newCollection;
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field groupId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field groupId had invalid length " + length);
        }
        this.groupId = _readable.readString(length);
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field memberId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field memberId had invalid length " + length);
        }
        this.memberId = _readable.readString(length);
        this.memberEpoch = _readable.readInt();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.instanceId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field instanceId had invalid length " + length);
            }
            this.instanceId = _readable.readString(length);
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.rackId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field rackId had invalid length " + length);
            }
            this.rackId = _readable.readString(length);
        }
        this.rebalanceTimeoutMs = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.subscribedTopicNames = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<String>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                int length2 = _readable.readUnsignedVarint() - 1;
                if (length2 < 0) {
                    throw new RuntimeException("non-nullable field subscribedTopicNames element was serialized as null");
                }
                if (length2 > Short.MAX_VALUE) {
                    throw new RuntimeException("string field subscribedTopicNames element had invalid length " + length2);
                }
                newCollection.add(_readable.readString(length2));
            }
            this.subscribedTopicNames = newCollection;
        }
        if (_version >= 1) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.subscribedTopicRegex = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field subscribedTopicRegex had invalid length " + length);
                }
                this.subscribedTopicRegex = _readable.readString(length);
            }
        } else {
            this.subscribedTopicRegex = null;
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.serverAssignor = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field serverAssignor had invalid length " + length);
            }
            this.serverAssignor = _readable.readString(length);
        }
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.topicPartitions = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((String)((Object)new TopicPartitions(_readable, _version)));
            }
            this.topicPartitions = newCollection;
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        Object _stringBytes = _cache.getSerializedValue(this.groupId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _stringBytes = _cache.getSerializedValue(this.memberId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeInt(this.memberEpoch);
        if (this.instanceId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.instanceId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.rackId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.rackId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeInt(this.rebalanceTimeoutMs);
        if (this.subscribedTopicNames == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.subscribedTopicNames.size() + 1);
            _stringBytes = this.subscribedTopicNames.iterator();
            while (_stringBytes.hasNext()) {
                String subscribedTopicNamesElement = (String)_stringBytes.next();
                byte[] _stringBytes2 = _cache.getSerializedValue(subscribedTopicNamesElement);
                _writable.writeUnsignedVarint(_stringBytes2.length + 1);
                _writable.writeByteArray(_stringBytes2);
            }
        }
        if (_version >= 1) {
            if (this.subscribedTopicRegex == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.subscribedTopicRegex);
                _writable.writeUnsignedVarint(((Object)_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
        } else if (this.subscribedTopicRegex != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default subscribedTopicRegex at version " + _version);
        }
        if (this.serverAssignor == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.serverAssignor);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.topicPartitions == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.topicPartitions.size() + 1);
            _stringBytes = this.topicPartitions.iterator();
            while (_stringBytes.hasNext()) {
                TopicPartitions topicPartitionsElement = (TopicPartitions)_stringBytes.next();
                topicPartitionsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        Object _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
        if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
            throw new RuntimeException("'groupId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.groupId, (byte[])_stringBytes);
        _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
        _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
        if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
            throw new RuntimeException("'memberId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.memberId, (byte[])_stringBytes);
        _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
        _size.addBytes(4);
        if (this.instanceId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.instanceId.getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'instanceId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.instanceId, (byte[])_stringBytes);
            _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
        }
        if (this.rackId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.rackId.getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'rackId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.rackId, (byte[])_stringBytes);
            _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
        }
        _size.addBytes(4);
        if (this.subscribedTopicNames == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.subscribedTopicNames.size() + 1));
            _stringBytes = this.subscribedTopicNames.iterator();
            while (_stringBytes.hasNext()) {
                String subscribedTopicNamesElement = (String)_stringBytes.next();
                byte[] _stringBytes2 = subscribedTopicNamesElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes2.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'subscribedTopicNamesElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(subscribedTopicNamesElement, _stringBytes2);
                _size.addBytes(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes2.length + 1));
            }
        }
        if (_version >= 1) {
            if (this.subscribedTopicRegex == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = this.subscribedTopicRegex.getBytes(StandardCharsets.UTF_8);
                if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                    throw new RuntimeException("'subscribedTopicRegex' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.subscribedTopicRegex, (byte[])_stringBytes);
                _size.addBytes(((Object)_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((Object)_stringBytes).length + 1));
            }
        }
        if (this.serverAssignor == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.serverAssignor.getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'serverAssignor' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.serverAssignor, (byte[])_stringBytes);
            _size.addBytes(((Object)_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((Object)_stringBytes).length + 1));
        }
        if (this.topicPartitions == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topicPartitions.size() + 1));
            for (TopicPartitions topicPartitionsElement : this.topicPartitions) {
                topicPartitionsElement.addSize(_size, _cache, _version);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConsumerGroupHeartbeatRequestData)) {
            return false;
        }
        ConsumerGroupHeartbeatRequestData other = (ConsumerGroupHeartbeatRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        if (this.memberEpoch != other.memberEpoch) {
            return false;
        }
        if (this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId)) {
            return false;
        }
        if (this.rackId == null ? other.rackId != null : !this.rackId.equals(other.rackId)) {
            return false;
        }
        if (this.rebalanceTimeoutMs != other.rebalanceTimeoutMs) {
            return false;
        }
        if (this.subscribedTopicNames == null ? other.subscribedTopicNames != null : !this.subscribedTopicNames.equals(other.subscribedTopicNames)) {
            return false;
        }
        if (this.subscribedTopicRegex == null ? other.subscribedTopicRegex != null : !this.subscribedTopicRegex.equals(other.subscribedTopicRegex)) {
            return false;
        }
        if (this.serverAssignor == null ? other.serverAssignor != null : !this.serverAssignor.equals(other.serverAssignor)) {
            return false;
        }
        if (this.topicPartitions == null ? other.topicPartitions != null : !this.topicPartitions.equals(other.topicPartitions)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        hashCode = 31 * hashCode + this.memberEpoch;
        hashCode = 31 * hashCode + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        hashCode = 31 * hashCode + (this.rackId == null ? 0 : this.rackId.hashCode());
        hashCode = 31 * hashCode + this.rebalanceTimeoutMs;
        hashCode = 31 * hashCode + (this.subscribedTopicNames == null ? 0 : this.subscribedTopicNames.hashCode());
        hashCode = 31 * hashCode + (this.subscribedTopicRegex == null ? 0 : this.subscribedTopicRegex.hashCode());
        hashCode = 31 * hashCode + (this.serverAssignor == null ? 0 : this.serverAssignor.hashCode());
        hashCode = 31 * hashCode + (this.topicPartitions == null ? 0 : this.topicPartitions.hashCode());
        return hashCode;
    }

    @Override
    public ConsumerGroupHeartbeatRequestData duplicate() {
        ConsumerGroupHeartbeatRequestData _duplicate = new ConsumerGroupHeartbeatRequestData();
        _duplicate.groupId = this.groupId;
        _duplicate.memberId = this.memberId;
        _duplicate.memberEpoch = this.memberEpoch;
        _duplicate.instanceId = this.instanceId == null ? null : this.instanceId;
        _duplicate.rackId = this.rackId == null ? null : this.rackId;
        _duplicate.rebalanceTimeoutMs = this.rebalanceTimeoutMs;
        if (this.subscribedTopicNames == null) {
            _duplicate.subscribedTopicNames = null;
        } else {
            ArrayList<String> newSubscribedTopicNames = new ArrayList<String>(this.subscribedTopicNames.size());
            for (String string : this.subscribedTopicNames) {
                newSubscribedTopicNames.add(string);
            }
            _duplicate.subscribedTopicNames = newSubscribedTopicNames;
        }
        _duplicate.subscribedTopicRegex = this.subscribedTopicRegex == null ? null : this.subscribedTopicRegex;
        _duplicate.serverAssignor = this.serverAssignor == null ? null : this.serverAssignor;
        if (this.topicPartitions == null) {
            _duplicate.topicPartitions = null;
        } else {
            ArrayList<TopicPartitions> newTopicPartitions = new ArrayList<TopicPartitions>(this.topicPartitions.size());
            for (TopicPartitions topicPartitions : this.topicPartitions) {
                newTopicPartitions.add(topicPartitions.duplicate());
            }
            _duplicate.topicPartitions = newTopicPartitions;
        }
        return _duplicate;
    }

    public String toString() {
        return "ConsumerGroupHeartbeatRequestData(groupId=" + (String)(this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", memberId=" + (String)(this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", memberEpoch=" + this.memberEpoch + ", instanceId=" + (String)(this.instanceId == null ? "null" : "'" + this.instanceId.toString() + "'") + ", rackId=" + (String)(this.rackId == null ? "null" : "'" + this.rackId.toString() + "'") + ", rebalanceTimeoutMs=" + this.rebalanceTimeoutMs + ", subscribedTopicNames=" + (this.subscribedTopicNames == null ? "null" : MessageUtil.deepToString(this.subscribedTopicNames.iterator())) + ", subscribedTopicRegex=" + (String)(this.subscribedTopicRegex == null ? "null" : "'" + this.subscribedTopicRegex.toString() + "'") + ", serverAssignor=" + (String)(this.serverAssignor == null ? "null" : "'" + this.serverAssignor.toString() + "'") + ", topicPartitions=" + (this.topicPartitions == null ? "null" : MessageUtil.deepToString(this.topicPartitions.iterator())) + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public String memberId() {
        return this.memberId;
    }

    public int memberEpoch() {
        return this.memberEpoch;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String rackId() {
        return this.rackId;
    }

    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public List<String> subscribedTopicNames() {
        return this.subscribedTopicNames;
    }

    public String subscribedTopicRegex() {
        return this.subscribedTopicRegex;
    }

    public String serverAssignor() {
        return this.serverAssignor;
    }

    public List<TopicPartitions> topicPartitions() {
        return this.topicPartitions;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ConsumerGroupHeartbeatRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public ConsumerGroupHeartbeatRequestData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    public ConsumerGroupHeartbeatRequestData setMemberEpoch(int v) {
        this.memberEpoch = v;
        return this;
    }

    public ConsumerGroupHeartbeatRequestData setInstanceId(String v) {
        this.instanceId = v;
        return this;
    }

    public ConsumerGroupHeartbeatRequestData setRackId(String v) {
        this.rackId = v;
        return this;
    }

    public ConsumerGroupHeartbeatRequestData setRebalanceTimeoutMs(int v) {
        this.rebalanceTimeoutMs = v;
        return this;
    }

    public ConsumerGroupHeartbeatRequestData setSubscribedTopicNames(List<String> v) {
        this.subscribedTopicNames = v;
        return this;
    }

    public ConsumerGroupHeartbeatRequestData setSubscribedTopicRegex(String v) {
        this.subscribedTopicRegex = v;
        return this;
    }

    public ConsumerGroupHeartbeatRequestData setServerAssignor(String v) {
        this.serverAssignor = v;
        return this;
    }

    public ConsumerGroupHeartbeatRequestData setTopicPartitions(List<TopicPartitions> v) {
        this.topicPartitions = v;
        return this;
    }

    public static class TopicPartitions
    implements Message {
        Uuid topicId;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public TopicPartitions(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicPartitions() {
            this.topicId = Uuid.ZERO_UUID;
            this.partitions = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicPartitions");
            }
            this.topicId = _readable.readUuid();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeUuid(this.topicId);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            for (Integer partitionsElement : this.partitions) {
                _writable.writeInt(partitionsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicPartitions");
            }
            _size.addBytes(16);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicPartitions)) {
                return false;
            }
            TopicPartitions other = (TopicPartitions)obj;
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public TopicPartitions duplicate() {
            TopicPartitions _duplicate = new TopicPartitions();
            _duplicate.topicId = this.topicId;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicPartitions(topicId=" + this.topicId.toString() + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicPartitions setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public TopicPartitions setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topic_id", Type.UUID, "The topic ID."), new Field("partitions", new CompactArrayOf(Type.INT32), "The partitions."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

