/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.X509TrustManager;
import org.ldaptive.ssl.CertificateHostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostnameVerifyingTrustManager
implements X509TrustManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String[] hostnames;
    private final CertificateHostnameVerifier hostnameVerifier;

    public HostnameVerifyingTrustManager(CertificateHostnameVerifier verifier, String ... names) {
        this.hostnameVerifier = verifier;
        this.hostnames = names;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkCertificateTrusted(chain[0]);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkCertificateTrusted(chain[0]);
    }

    private void checkCertificateTrusted(X509Certificate cert) throws CertificateException {
        for (String name : this.hostnames) {
            if (!this.hostnameVerifier.verify(name, cert)) continue;
            this.logger.debug("checkCertificateTrusted for {} succeeded against {}", (Object)this.hostnameVerifier, (Object)(cert != null ? cert.getSubjectX500Principal() : null));
            return;
        }
        throw new CertificateException(String.format("Hostname '%s' does not match the hostname in the server's certificate '%s'", Arrays.toString(this.hostnames), cert != null ? cert.getSubjectX500Principal() : null));
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    public String toString() {
        return String.format("[%s@%d::hostnameVerifier=%s, hostnames=%s]", this.getClass().getName(), this.hashCode(), this.hostnameVerifier, Arrays.toString(this.hostnames));
    }
}

