/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.xml.DOMTypeSupport;
import net.shibboleth.shared.xml.QNameSupport;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.w3c.dom.Element;

public abstract class AbstractXMLObjectBuilder<XMLObjectType extends XMLObject>
implements XMLObjectBuilder<XMLObjectType> {
    @Override
    @Nonnull
    public XMLObjectType buildObject(@Nonnull QName objectName) {
        return this.buildObject(objectName.getNamespaceURI(), QNameSupport.ensureLocalPart(objectName), objectName.getPrefix());
    }

    @Override
    @Nonnull
    public XMLObjectType buildObject(@Nonnull QName objectName, @Nullable QName schemaType) {
        return this.buildObject(objectName.getNamespaceURI(), QNameSupport.ensureLocalPart(objectName), objectName.getPrefix(), schemaType);
    }

    @Override
    @Nonnull
    public abstract XMLObjectType buildObject(@Nullable String var1, @Nonnull @NotEmpty String var2, @Nullable String var3);

    @Override
    @Nonnull
    public XMLObjectType buildObject(@Nullable String namespaceURI, @Nonnull String localName, @Nullable String namespacePrefix, @Nullable QName schemaType) {
        XMLObjectType xmlObject = this.buildObject(namespaceURI, localName, namespacePrefix);
        if (xmlObject instanceof AbstractXMLObject) {
            AbstractXMLObject downcast = (AbstractXMLObject)xmlObject;
            downcast.setSchemaType(schemaType);
        }
        return xmlObject;
    }

    @Override
    @Nonnull
    public XMLObjectType buildObject(@Nonnull Element element) {
        QName schemaType = DOMTypeSupport.getXSIType(element);
        return this.buildObject(QNameSupport.getNodeQName(element), schemaType);
    }
}

