/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.context.navigate;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;

public class RecursiveTypedChildContextLookup<ChildContext extends BaseContext>
implements ContextDataLookupFunction<BaseContext, ChildContext> {
    @Nonnull
    private Class<ChildContext> childClass;

    public RecursiveTypedChildContextLookup(@Nonnull @ParameterName(name="targetClass") Class<ChildContext> targetClass) {
        this.childClass = Constraint.isNotNull(targetClass, "Child Class cannot be null");
    }

    @Override
    @Nullable
    public ChildContext apply(@Nullable BaseContext input) {
        if (input == null) {
            return null;
        }
        for (BaseContext subcontext : input) {
            if (this.childClass.isInstance(subcontext)) {
                return (ChildContext)((BaseContext)this.childClass.cast(subcontext));
            }
            ChildContext found = this.apply(subcontext);
            if (found == null) continue;
            return found;
        }
        return null;
    }
}

