/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.context.navigate;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;

public class RootContextLookup<StartContext extends BaseContext, RootContext extends BaseContext>
implements ContextDataLookupFunction<StartContext, RootContext> {
    @Nullable
    private final Class<RootContext> claz;

    public RootContextLookup() {
        this.claz = null;
    }

    public RootContextLookup(@Nonnull @ParameterName(name="targetClass") Class<RootContext> targetClass) {
        this.claz = Constraint.isNotNull(targetClass, "RootContext type cannot be null");
    }

    @Override
    @Nullable
    public RootContext apply(@Nullable BaseContext input) {
        if (input == null) {
            return null;
        }
        if (input.getParent() == null) {
            if (this.claz != null) {
                if (this.claz.isInstance(input)) {
                    assert (this.claz != null);
                    return (RootContext)((BaseContext)this.claz.cast(input));
                }
                throw new ClassCastException("Root context was not of the expected type");
            }
            return (RootContext)input;
        }
        return this.apply(input.getParent());
    }
}

