/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.SignatureSigningParametersResolver;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.slf4j.Logger;

public class PopulateSignatureSigningParametersHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateSignatureSigningParametersHandler.class);
    @Nonnull
    private Function<MessageContext, SecurityParametersContext> securityParametersContextLookupStrategy = new ChildContextLookup<MessageContext, SecurityParametersContext>(SecurityParametersContext.class, true);
    @Nullable
    private Function<MessageContext, SecurityParametersContext> existingParametersContextLookupStrategy;
    @NonnullAfterInit
    private Function<MessageContext, List<SignatureSigningConfiguration>> configurationLookupStrategy;
    @Nullable
    private Function<MessageContext, SAMLMetadataContext> metadataContextLookupStrategy = new ChildContextLookup(SAMLMetadataContext.class).compose(new ChildContextLookup(SAMLPeerEntityContext.class));
    @NonnullAfterInit
    private SignatureSigningParametersResolver resolver;
    private boolean noResultIsError;

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<MessageContext, SecurityParametersContext> strategy) {
        this.checkSetterPreconditions();
        this.securityParametersContextLookupStrategy = Constraint.isNotNull(strategy, "SecurityParametersContext lookup strategy cannot be null");
    }

    public void setExistingParametersContextLookupStrategy(@Nullable Function<MessageContext, SecurityParametersContext> strategy) {
        this.checkSetterPreconditions();
        this.existingParametersContextLookupStrategy = strategy;
    }

    public void setMetadataContextLookupStrategy(@Nullable Function<MessageContext, SAMLMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.metadataContextLookupStrategy = strategy;
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<MessageContext, List<SignatureSigningConfiguration>> strategy) {
        this.checkSetterPreconditions();
        this.configurationLookupStrategy = Constraint.isNotNull(strategy, "SignatureSigningConfiguration lookup strategy cannot be null");
    }

    public void setSignatureSigningParametersResolver(@Nonnull SignatureSigningParametersResolver newResolver) {
        this.checkSetterPreconditions();
        this.resolver = Constraint.isNotNull(newResolver, "SignatureSigningParametersResolver cannot be null");
    }

    public void setNoResultIsError(boolean flag) {
        this.checkSetterPreconditions();
        this.noResultIsError = flag;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolver == null) {
            throw new ComponentInitializationException("SignatureSigningParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            this.configurationLookupStrategy = new Function<MessageContext, List<SignatureSigningConfiguration>>(){

                @Override
                public List<SignatureSigningConfiguration> apply(MessageContext input) {
                    return CollectionSupport.singletonList(SecurityConfigurationSupport.ensureGlobalSignatureSigningConfiguration());
                }
            };
        }
    }

    @Override
    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (super.doPreInvoke(messageContext)) {
            this.log.debug("{} Signing enabled", (Object)this.getLogPrefix());
            return true;
        }
        this.log.debug("{} Signing not enabled", (Object)this.getLogPrefix());
        return false;
    }

    @Override
    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        RoleDescriptor role;
        SAMLMetadataContext metadataCtx;
        SecurityParametersContext existingCtx;
        this.log.debug("{} Resolving SignatureSigningParameters for request", (Object)this.getLogPrefix());
        SecurityParametersContext paramsCtx = this.securityParametersContextLookupStrategy.apply(messageContext);
        if (paramsCtx == null) {
            this.log.debug("{} No SecurityParametersContext returned by lookup strategy", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No SecurityParametersContext returned by lookup strategy");
        }
        if (this.existingParametersContextLookupStrategy != null && (existingCtx = this.existingParametersContextLookupStrategy.apply(messageContext)) != null && existingCtx.getSignatureSigningParameters() != null) {
            this.log.debug("{} Found existing SecurityParametersContext to copy from", (Object)this.getLogPrefix());
            paramsCtx.setSignatureSigningParameters(existingCtx.getSignatureSigningParameters());
            return;
        }
        List<SignatureSigningConfiguration> configs = this.configurationLookupStrategy.apply(messageContext);
        if (configs == null || configs.isEmpty()) {
            this.log.error("{} No SignatureSigningConfiguration returned by lookup strategy", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No SignatureSigningConfiguration returned by lookup strategy");
        }
        CriteriaSet criteria = new CriteriaSet(new SignatureSigningConfigurationCriterion(configs));
        if (this.metadataContextLookupStrategy != null && (metadataCtx = this.metadataContextLookupStrategy.apply(messageContext)) != null && (role = metadataCtx.getRoleDescriptor()) != null) {
            this.log.debug("{} Adding metadata to resolution criteria for signing/digest algorithms", (Object)this.getLogPrefix());
            criteria.add(new RoleDescriptorCriterion(role));
        }
        try {
            SignatureSigningParameters params = (SignatureSigningParameters)this.resolver.resolveSingle(criteria);
            if (params == null && this.noResultIsError) {
                this.log.error("Failed to resolve SignatureSigningParameters");
                throw new MessageHandlerException("Failed to resolve SignatureSigningParameters");
            }
            this.log.debug("{} {} SignatureSigningParameters", (Object)this.getLogPrefix(), (Object)(params != null ? "Resolved" : "Failed to resolve"));
            paramsCtx.setSignatureSigningParameters(params);
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving SignatureSigningParameters: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            throw new MessageHandlerException("Error resolving SignatureSigningParameters", e);
        }
    }
}

