/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.shared.xml.AttributeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.AbstractSAMLObjectMarshaller;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.ResponseAbstractType;
import org.w3c.dom.Element;

public abstract class ResponseAbstractTypeMarshaller
extends AbstractSAMLObjectMarshaller {
    @Override
    protected void marshallAttributes(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        SAMLVersion version;
        Instant i;
        ResponseAbstractType response = (ResponseAbstractType)xmlObject;
        if (response.getID() != null) {
            domElement.setAttributeNS(null, "ResponseID", response.getID());
        }
        if (response.getInResponseTo() != null) {
            domElement.setAttributeNS(null, "InResponseTo", response.getInResponseTo());
        }
        if ((i = response.getIssueInstant()) != null) {
            AttributeSupport.appendDateTimeAttribute(domElement, ResponseAbstractType.ISSUEINSTANT_ATTRIB_QNAME, i);
        }
        if ((version = response.getVersion()) != null) {
            domElement.setAttributeNS(null, "MajorVersion", Integer.toString(version.getMajorVersion()));
            domElement.setAttributeNS(null, "MinorVersion", Integer.toString(version.getMinorVersion()));
        }
        if (response.getRecipient() != null) {
            domElement.setAttributeNS(null, "Recipient", response.getRecipient());
        }
    }

    @Override
    protected void marshallAttributeIDness(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        if (((ResponseAbstractType)xmlObject).getVersion() != SAMLVersion.VERSION_10) {
            XMLObjectSupport.marshallAttributeIDness(null, "ResponseID", domElement, true);
        }
    }
}

