/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.security.impl;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.xml.ParserPool;
import net.shibboleth.shared.xml.XMLParserException;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.binding.security.impl.BaseSAMLSimpleSignatureSecurityHandler;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCriterion;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.slf4j.Logger;
import org.w3c.dom.Document;

public class SAML2HTTPPostSimpleSignSecurityHandler
extends BaseSAMLSimpleSignatureSecurityHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SAML2HTTPPostSimpleSignSecurityHandler.class);
    @NonnullAfterInit
    private ParserPool parserPool;
    @NonnullAfterInit
    private KeyInfoCredentialResolver keyInfoResolver;

    @NonnullAfterInit
    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public void setParser(@Nonnull ParserPool newParserPool) {
        this.checkSetterPreconditions();
        this.parserPool = Constraint.isNotNull(newParserPool, "ParserPool cannot be null");
    }

    @NonnullAfterInit
    public KeyInfoCredentialResolver getKeyInfoResolver() {
        return this.keyInfoResolver;
    }

    public void setKeyInfoResolver(@Nonnull KeyInfoCredentialResolver newKeyInfoResolver) {
        this.checkSetterPreconditions();
        this.keyInfoResolver = Constraint.isNotNull(newKeyInfoResolver, "KeyInfoCredentialResolver cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        Constraint.isNotNull(this.parserPool, "ParserPool cannot be null");
        Constraint.isNotNull(this.keyInfoResolver, "KeyInfoCredentialResolver cannot be null");
    }

    @Override
    protected boolean ruleHandles(@Nonnull MessageContext messageContext) {
        return "POST".equals(this.getHttpServletRequest().getMethod()) && "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign".equals(messageContext.ensureSubcontext(SAMLBindingContext.class).getBindingUri());
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    protected List<Credential> getRequestCredentials(@Nonnull MessageContext samlContext) throws MessageHandlerException {
        String kiBase64 = this.getHttpServletRequest().getParameter("KeyInfo");
        if (Strings.isNullOrEmpty((String)kiBase64)) {
            this.log.debug("Form control data did not contain a KeyInfo");
            return CollectionSupport.emptyList();
        }
        this.log.debug("Found a KeyInfo in form control data, extracting validation credentials");
        Unmarshaller unmarshaller = XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(KeyInfo.DEFAULT_ELEMENT_NAME);
        if (unmarshaller == null) {
            throw new MessageHandlerException("Could not obtain a KeyInfo unmarshaller");
        }
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(Base64Support.decode(kiBase64));
        }
        catch (DecodingException e) {
            this.log.warn("Error base64 decoding KeyInfo data: {}", (Object)e.getMessage());
            throw new MessageHandlerException("Error base64 decoding KeyInfo data", e);
        }
        KeyInfo keyInfo = null;
        try {
            Document doc = this.getParserPool().parse(is);
            keyInfo = (KeyInfo)unmarshaller.unmarshall(doc.getDocumentElement());
        }
        catch (XMLParserException e) {
            this.log.warn("Error parsing KeyInfo data: {}", (Object)e.getMessage());
            throw new MessageHandlerException("Error parsing KeyInfo data", e);
        }
        catch (UnmarshallingException e) {
            this.log.warn("Error unmarshalling KeyInfo data: {}", (Object)e.getMessage());
            throw new MessageHandlerException("Error unmarshalling KeyInfo data", e);
        }
        ArrayList<Credential> credentials = new ArrayList<Credential>();
        CriteriaSet criteriaSet = new CriteriaSet(new KeyInfoCriterion(keyInfo));
        try {
            for (Credential cred : this.keyInfoResolver.resolve(criteriaSet)) {
                credentials.add(cred);
            }
        }
        catch (ResolverException e) {
            this.log.warn("Error resolving credentials from KeyInfo: {}", (Object)e.getMessage());
            throw new MessageHandlerException("Error resolving credentials from KeyInfo", e);
        }
        return credentials;
    }
}

