/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml.saml2.metadata.AffiliateMember;
import org.opensaml.saml.saml2.metadata.AffiliationDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.xmlsec.signature.Signature;
import org.w3c.dom.Attr;

public class AffiliationDescriptorUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    @Override
    protected void processChildElement(@Nonnull XMLObject parentObject, @Nonnull XMLObject childObject) throws UnmarshallingException {
        AffiliationDescriptor descriptor = (AffiliationDescriptor)parentObject;
        if (childObject instanceof Extensions) {
            descriptor.setExtensions((Extensions)childObject);
        } else if (childObject instanceof Signature) {
            descriptor.setSignature((Signature)childObject);
        } else if (childObject instanceof AffiliateMember) {
            descriptor.getMembers().add((AffiliateMember)childObject);
        } else if (childObject instanceof KeyDescriptor) {
            descriptor.getKeyDescriptors().add((KeyDescriptor)childObject);
        } else {
            super.processChildElement(parentObject, childObject);
        }
    }

    @Override
    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        AffiliationDescriptor descriptor = (AffiliationDescriptor)xmlObject;
        if (attribute.getNamespaceURI() == null) {
            if (attribute.getLocalName().equals("affiliationOwnerID")) {
                descriptor.setOwnerID(attribute.getValue());
            } else if (attribute.getLocalName().equals("ID")) {
                descriptor.setID(attribute.getValue());
                attribute.getOwnerElement().setIdAttributeNode(attribute, true);
            } else if (attribute.getLocalName().equals("validUntil") && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                descriptor.setValidUntil(DOMTypeSupport.stringToInstant(attribute.getValue()));
            } else if (attribute.getLocalName().equals("cacheDuration")) {
                descriptor.setCacheDuration(DOMTypeSupport.stringToDuration(attribute.getValue()));
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        } else {
            this.processUnknownAttribute(descriptor, attribute);
        }
    }
}

