/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import java.security.Key;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.AbstractTriStatePredicate;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.criteria.KeyAlgorithmCriterion;
import org.slf4j.Logger;

public class EvaluableKeyAlgorithmCredentialCriterion
extends AbstractTriStatePredicate<Credential>
implements EvaluableCredentialCriterion {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EvaluableKeyAlgorithmCredentialCriterion.class);
    @Nonnull
    private final String keyAlgorithm;

    public EvaluableKeyAlgorithmCredentialCriterion(@Nonnull KeyAlgorithmCriterion criteria) {
        this.keyAlgorithm = Constraint.isNotNull(criteria, "Criterion instance cannot be null").getKeyAlgorithm();
    }

    public EvaluableKeyAlgorithmCredentialCriterion(@Nonnull String newKeyAlgorithm) {
        String trimmed = StringSupport.trimOrNull(newKeyAlgorithm);
        this.keyAlgorithm = Constraint.isNotNull(trimmed, "Key algorithm cannot be null or empty");
    }

    @Override
    public boolean test(@Nullable Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return this.isNullInputSatisfies();
        }
        Key key = this.getKey(target);
        if (key == null) {
            this.log.info("Could not evaluate criteria, credential contained no key");
            return this.isUnevaluableSatisfies();
        }
        String algorithm = StringSupport.trimOrNull(key.getAlgorithm());
        if (algorithm == null) {
            this.log.info("Could not evaluate criteria, key does not specify an algorithm via getAlgorithm()");
            return this.isUnevaluableSatisfies();
        }
        return this.keyAlgorithm.equals(algorithm);
    }

    @Nullable
    private Key getKey(@Nonnull Credential credential) {
        if (credential.getPublicKey() != null) {
            return credential.getPublicKey();
        }
        if (credential.getSecretKey() != null) {
            return credential.getSecretKey();
        }
        if (credential.getPrivateKey() != null) {
            return credential.getPrivateKey();
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EvaluableKeyAlgorithmCredentialCriterion [keyAlgorithm=");
        builder.append(this.keyAlgorithm);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.keyAlgorithm.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof EvaluableKeyAlgorithmCredentialCriterion) {
            EvaluableKeyAlgorithmCredentialCriterion other = (EvaluableKeyAlgorithmCredentialCriterion)obj;
            return this.keyAlgorithm.equals(other.keyAlgorithm);
        }
        return false;
    }
}

