/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.tls;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.security.x509.InternalX500DNHandler;
import org.opensaml.security.x509.X500DNHandler;

public class CertificateNameOptions
implements Cloneable {
    private boolean evaluateSubjectDN;
    private boolean evaluateSubjectCommonName;
    @Nonnull
    private Set<Integer> subjectAltNames = CollectionSupport.emptySet();
    @Nonnull
    private X500DNHandler x500DNHandler = new InternalX500DNHandler();
    @Nonnull
    private String x500SubjectDNFormat = "RFC2253";

    public boolean evaluateSubjectCommonName() {
        return this.evaluateSubjectCommonName;
    }

    public void setEvaluateSubjectCommonName(boolean flag) {
        this.evaluateSubjectCommonName = flag;
    }

    public boolean evaluateSubjectDN() {
        return this.evaluateSubjectDN;
    }

    public void setEvaluateSubjectDN(boolean flag) {
        this.evaluateSubjectDN = flag;
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<Integer> getSubjectAltNames() {
        return this.subjectAltNames;
    }

    public void setSubjectAltNames(@Nullable Set<Integer> names) {
        this.subjectAltNames = names == null ? CollectionSupport.emptySet() : CollectionSupport.copyToSet(names);
    }

    @Nonnull
    public X500DNHandler getX500DNHandler() {
        return this.x500DNHandler;
    }

    public void setX500DNHandler(@Nonnull X500DNHandler handler) {
        this.x500DNHandler = Constraint.isNotNull(handler, "X500DNHandler cannot be null");
    }

    @Nonnull
    public String getX500SubjectDNFormat() {
        return this.x500SubjectDNFormat;
    }

    public void setX500SubjectDNFormat(@Nonnull String format) {
        this.x500SubjectDNFormat = Constraint.isNotNull(format, "X.500 Subject DN Format cannot be null");
    }

    public CertificateNameOptions clone() {
        CertificateNameOptions clonedOptions;
        try {
            clonedOptions = (CertificateNameOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        clonedOptions.subjectAltNames = new LinkedHashSet<Integer>();
        clonedOptions.subjectAltNames.addAll(this.subjectAltNames);
        clonedOptions.x500DNHandler = this.x500DNHandler.clone();
        return clonedOptions;
    }
}

