/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.xmlsec.SignatureValidationConfiguration;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.SignatureValidationParametersResolver;
import org.opensaml.xmlsec.criterion.SignatureValidationConfigurationCriterion;
import org.opensaml.xmlsec.impl.AbstractSecurityParametersResolver;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.slf4j.Logger;

public class BasicSignatureValidationParametersResolver
extends AbstractSecurityParametersResolver<SignatureValidationParameters>
implements SignatureValidationParametersResolver {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(BasicSignatureValidationParametersResolver.class);

    @Override
    @Nonnull
    public Iterable<SignatureValidationParameters> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        SignatureValidationParameters params = this.resolveSingle(criteria);
        if (params != null) {
            return CollectionSupport.singletonList(params);
        }
        return CollectionSupport.emptyList();
    }

    @Override
    @Nullable
    public SignatureValidationParameters resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        if (criteria == null) {
            this.log.debug("CriteriaSet was null");
            return null;
        }
        SignatureValidationConfigurationCriterion criterion = Constraint.isNotNull(criteria.get(SignatureValidationConfigurationCriterion.class), "Resolver requires an instance of SignatureValidationConfigurationCriterion");
        SignatureValidationParameters params = new SignatureValidationParameters();
        this.resolveAndPopulateIncludesExcludes(params, criteria, criterion.getConfigurations());
        params.setSignatureTrustEngine(this.resolveSignatureTrustEngine(criteria));
        this.logResult(params);
        return params;
    }

    protected void logResult(@Nonnull SignatureValidationParameters params) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resolved SignatureValidationParameters:");
            this.log.debug("\tAlgorithm includes: {}", params.getIncludedAlgorithms());
            this.log.debug("\tAlgorithm excludes: {}", params.getExcludedAlgorithms());
            this.log.debug("\tSignatureTrustEngine: {}", (Object)(params.getSignatureTrustEngine() != null ? "present" : "null"));
        }
    }

    @Nullable
    protected SignatureTrustEngine resolveSignatureTrustEngine(@Nonnull CriteriaSet criteria) {
        SignatureValidationConfigurationCriterion criterion = criteria.get(SignatureValidationConfigurationCriterion.class);
        assert (criterion != null);
        for (SignatureValidationConfiguration config : criterion.getConfigurations()) {
            if (config.getSignatureTrustEngine() == null) continue;
            return config.getSignatureTrustEngine();
        }
        return null;
    }
}

