/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class SignatureAlgorithmValidator {
    @Nonnull
    private static final QName ELEMENT_NAME_SIGNED_INFO = new QName("http://www.w3.org/2000/09/xmldsig#", "SignedInfo");
    @Nonnull
    private static final QName ELEMENT_NAME_SIGNATURE_METHOD = new QName("http://www.w3.org/2000/09/xmldsig#", "SignatureMethod");
    @Nonnull
    private static final QName ELEMENT_NAME_REFERENCE = new QName("http://www.w3.org/2000/09/xmldsig#", "Reference");
    @Nonnull
    private static final QName ELEMENT_NAME_DIGEST_METHOD = new QName("http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
    @Nonnull
    @NotEmpty
    private static final String ATTR_NAME_ALGORTHM = "Algorithm";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SignatureAlgorithmValidator.class);
    @Nullable
    private Collection<String> includedAlgorithmURIs;
    @Nullable
    private Collection<String> excludedAlgorithmURIs;

    public SignatureAlgorithmValidator(@Nonnull @ParameterName(name="params") SignatureValidationParameters params) {
        Constraint.isNotNull(params, "SignatureValidationParameters may not be null");
        this.includedAlgorithmURIs = params.getIncludedAlgorithms();
        this.excludedAlgorithmURIs = params.getExcludedAlgorithms();
    }

    public SignatureAlgorithmValidator(@Nullable @ParameterName(name="includeAlgos") Collection<String> includeAlgos, @Nullable @ParameterName(name="excludeAlgos") Collection<String> excludeAlgos) {
        this.includedAlgorithmURIs = includeAlgos;
        this.excludedAlgorithmURIs = excludeAlgos;
    }

    public void validate(@Nonnull Signature signature) throws SignatureException {
        Constraint.isNotNull(signature, "Signature was null");
        this.checkDOM(signature);
        String signatureAlgorithm = this.getSignatureAlgorithm(signature);
        this.log.debug("Validating SignedInfo/SignatureMethod/@Algorithm against include/exclude lists: {}", (Object)signatureAlgorithm);
        this.validateAlgorithmURI(signatureAlgorithm);
        for (String digestMethod : this.getDigestMethods(signature)) {
            assert (digestMethod != null);
            this.log.debug("Validating SignedInfo/Reference/DigestMethod/@Algorithm against include/exclude lists: {}", (Object)digestMethod);
            this.validateAlgorithmURI(digestMethod);
        }
    }

    protected void checkDOM(@Nonnull Signature signature) throws SignatureException {
        if (signature.getDOM() == null) {
            this.log.warn("Signature does not have a cached DOM Element");
            throw new SignatureException("Signature does not have a cached DOM Element");
        }
    }

    @Nonnull
    protected String getSignatureAlgorithm(@Nonnull Signature signatureXMLObject) throws SignatureException {
        String signatureMethodAlgorithm;
        Element signatureMethod;
        Element signedInfo;
        Element signature = signatureXMLObject.getDOM();
        if (signature != null && (signedInfo = ElementSupport.getFirstChildElement(signature, ELEMENT_NAME_SIGNED_INFO)) != null && (signatureMethod = ElementSupport.getFirstChildElement(signedInfo, ELEMENT_NAME_SIGNATURE_METHOD)) != null && (signatureMethodAlgorithm = StringSupport.trimOrNull(AttributeSupport.getAttributeValue(signatureMethod, null, ATTR_NAME_ALGORTHM))) != null) {
            return signatureMethodAlgorithm;
        }
        throw new SignatureException("Signature/SignedInfo/SignatureMethod elements or Algorithm were null");
    }

    @Nonnull
    protected List<String> getDigestMethods(@Nonnull Signature signatureXMLObject) throws SignatureException {
        ArrayList<String> digestMethodAlgorithms = new ArrayList<String>();
        Element signature = signatureXMLObject.getDOM();
        if (signature == null) {
            this.log.warn("Signature element was null");
            return digestMethodAlgorithms;
        }
        Element signedInfo = ElementSupport.getFirstChildElement(signature, ELEMENT_NAME_SIGNED_INFO);
        if (signedInfo == null) {
            this.log.warn("SignedInfo element was absent");
            return digestMethodAlgorithms;
        }
        for (Element reference : ElementSupport.getChildElements(signedInfo, ELEMENT_NAME_REFERENCE)) {
            assert (reference != null);
            Element digestMethod = ElementSupport.getFirstChildElement(reference, ELEMENT_NAME_DIGEST_METHOD);
            if (digestMethod == null) continue;
            String digestMethodAlgorithm = StringSupport.trimOrNull(AttributeSupport.getAttributeValue(digestMethod, null, ATTR_NAME_ALGORTHM));
            if (digestMethodAlgorithm != null) {
                digestMethodAlgorithms.add(digestMethodAlgorithm);
                continue;
            }
            throw new SignatureException("DigestMethod Algorithm was null");
        }
        return digestMethodAlgorithms;
    }

    protected void validateAlgorithmURI(@Nonnull String algorithmURI) throws SignatureException {
        this.log.debug("Validating algorithm URI against include and exclude: algorithm: {}, includes: {}, excludes: {}", new Object[]{algorithmURI, this.includedAlgorithmURIs, this.excludedAlgorithmURIs});
        if (!AlgorithmSupport.validateAlgorithmURI(algorithmURI, this.includedAlgorithmURIs, this.excludedAlgorithmURIs)) {
            throw new SignatureException("Algorithm failed include/exclude validation: " + algorithmURI);
        }
    }
}

