/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.Lazy;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;
import net.sourceforge.plantuml.stereo.Stereotag;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.utils.BlocLines;

public class CommandNoteLong3
extends CommandMultilines2<ActivityDiagram3> {
    private static final Lazy<Pattern2> END = new Lazy<Pattern2>(() -> Pattern2.cmpile("^end[%s]?note$"));

    public CommandNoteLong3() {
        super(CommandNoteLong3.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH, END);
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeNow(ActivityDiagram3 diagram, BlocLines lines, ParserPass currentPass) throws NoSuchColorException {
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        lines = lines.subExtract(1, 1);
        lines = lines.removeEmptyColumns();
        NotePosition position = NotePosition.defaultLeft(line0.get("POSITION", 0));
        NoteType type = NoteType.defaultType(line0.get("TYPE", 0));
        Display note = lines.toDisplay();
        Colors colors = CommandNoteLong3.color().getColor(line0, diagram.getSkinParam().getIHtmlColorSet());
        String stereotypeString = line0.get("STEREO", 0);
        Stereotype stereotype = null;
        if (stereotypeString != null) {
            stereotype = Stereotype.build(stereotypeString);
        }
        return diagram.addNote(note, position, type, colors, stereotype);
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandNoteLong3.class.getName(), RegexLeaf.start(), new RegexLeaf(1, "TYPE", "(note|floating note)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "POSITION", "(left|right)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(4, "TAGS", Stereotag.pattern() + "?"), StereotypePattern.optional("STEREO"), CommandNoteLong3.color().getRegex(), RegexLeaf.end());
    }
}

