/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.licensing;

import java.io.IOException;

public class BitInput {
    private final byte[] buf;
    private int byteIndex = 0;
    private int bitIndex = 0;

    BitInput(byte[] buf) {
        this.buf = buf;
    }

    int availableBits() {
        return (this.buf.length - this.byteIndex) * 8 - this.bitIndex;
    }

    boolean readBit() throws IOException {
        if (this.byteIndex >= this.buf.length) {
            throw new IOException();
        }
        int current = this.buf[this.byteIndex] & 0xFF;
        boolean bit = (current >> this.bitIndex & 1) == 1;
        ++this.bitIndex;
        if (this.bitIndex == 8) {
            this.bitIndex = 0;
            ++this.byteIndex;
        }
        return bit;
    }
}

