/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mindmap;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.plantuml.mindmap.Stripe;

public class StripeFrontier {
    private final SortedSet<Stripe> stripes = new TreeSet<Stripe>();

    public StripeFrontier() {
        this.stripes.add(new Stripe(-1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308));
    }

    public boolean isEmpty() {
        return this.stripes.size() == 1;
    }

    public String toString() {
        return this.stripes.toString();
    }

    public boolean contains(double x, double y) {
        for (Stripe stripe : this.stripes) {
            if (!stripe.contains(x)) continue;
            return y <= stripe.getValue();
        }
        throw new UnsupportedOperationException();
    }

    public double getContact(double x1, double x2) {
        SortedSet<Stripe> collisions = this.collisionning(x1, x2);
        double result = -1.7976931348623157E308;
        for (Stripe strip : collisions) {
            result = Math.max(result, strip.getValue());
        }
        return result;
    }

    public void addSegment(double x1, double x2, double value) {
        if (x2 <= x1) {
            System.err.println("x1=" + x1);
            System.err.println("x2=" + x2);
            throw new IllegalArgumentException();
        }
        SortedSet<Stripe> collisions = this.collisionning(x1, x2);
        if (collisions.size() > 1) {
            Iterator it = collisions.iterator();
            it.next();
            double x = x1;
            while (it.hasNext()) {
                Stripe tmp = (Stripe)it.next();
                this.addSegment(x, tmp.getStart(), value);
                x = tmp.getStart();
            }
            this.addSegment(x, x2, value);
        } else {
            Stripe touch = (Stripe)collisions.iterator().next();
            this.addSingleInternal(x1, x2, value, touch);
        }
    }

    private void addSingleInternal(double x1, double x2, double value, Stripe touch) {
        if (value <= touch.getValue()) {
            return;
        }
        boolean ok = this.stripes.remove(touch);
        assert (ok);
        if (touch.getStart() != x1) {
            this.stripes.add(new Stripe(touch.getStart(), x1, touch.getValue()));
        }
        this.stripes.add(new Stripe(x1, x2, value));
        if (x2 != touch.getEnd()) {
            this.stripes.add(new Stripe(x2, touch.getEnd(), touch.getValue()));
        }
        assert (this.checkConsistent());
    }

    private boolean checkConsistent() {
        Stripe last = null;
        for (Stripe stripe : this.stripes) {
            if (last == null && stripe.getStart() != -1.7976931348623157E308) {
                return false;
            }
            if (last != null && last.getEnd() != stripe.getStart()) {
                return false;
            }
            last = stripe;
        }
        return last.getEnd() == Double.MAX_VALUE;
    }

    private SortedSet<Stripe> collisionning(double x1, double x2) {
        TreeSet<Stripe> result = new TreeSet<Stripe>();
        for (Stripe stripe : this.stripes) {
            if (x1 >= stripe.getEnd()) continue;
            result.add(stripe);
            if (!(x2 <= stripe.getEnd())) continue;
            return result;
        }
        throw new UnsupportedOperationException();
    }
}

