/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.url;

import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlMode;

public class UrlBuilder {
    public static final IRegex MANDATORY = new RegexLeaf(12, "URL", "(" + UrlBuilder.getRegexp() + ")");
    public static final IRegex OPTIONAL = new RegexOptional(MANDATORY);
    private static final String START_PART = "\\[\\[[%s]*";
    private static final String END_PART = "[%s]*\\]\\]";
    private static final String S_QUOTED = "\\[\\[[%s]*[%g]([^%g]+)[%g](?:[%s]*\\{([^{}]*)\\})?(?:[%s]([^%s\\{\\}\\[\\]][^\\[\\]]*))?[%s]*\\]\\]";
    private static final String S_ONLY_TOOLTIP = "\\[\\[[%s]*\\{(.*)\\}[%s]*\\]\\]";
    private static final String S_ONLY_TOOLTIP_AND_LABEL = "\\[\\[[%s]*\\{([^{}]*)\\}[%s]*([^\\[%s\\{\\}\\[\\]][^\\[\\]]*)[%s]*\\]\\]";
    private static final String S_LINK_TOOLTIP_NOLABEL = "\\[\\[[%s]*([^\\s%g{}\\[\\]]+?)[%s]*\\{(.+)\\}[%s]*\\]\\]";
    private static final String S_LINK_WITH_OPTIONAL_TOOLTIP_WITH_OPTIONAL_LABEL = "\\[\\[[%s]*([^%s%g\\[\\]]+?)(?:[%s]*\\{([^{}]*)\\})?(?:[%s]([^%s\\{\\}\\[\\]][^\\[\\]]*))?[%s]*\\]\\]";
    private static final Pattern2 QUOTED = Pattern2.cmpile("\\[\\[[%s]*[%g]([^%g]+)[%g](?:[%s]*\\{([^{}]*)\\})?(?:[%s]([^%s\\{\\}\\[\\]][^\\[\\]]*))?[%s]*\\]\\]");
    private static final Pattern2 ONLY_TOOLTIP = Pattern2.cmpile("\\[\\[[%s]*\\{(.*)\\}[%s]*\\]\\]");
    private static final Pattern2 ONLY_TOOLTIP_AND_LABEL = Pattern2.cmpile("\\[\\[[%s]*\\{([^{}]*)\\}[%s]*([^\\[%s\\{\\}\\[\\]][^\\[\\]]*)[%s]*\\]\\]");
    private static final Pattern2 LINK_TOOLTIP_NOLABEL = Pattern2.cmpile("\\[\\[[%s]*([^\\s%g{}\\[\\]]+?)[%s]*\\{(.+)\\}[%s]*\\]\\]");
    private static final Pattern2 LINK_WITH_OPTIONAL_TOOLTIP_WITH_OPTIONAL_LABEL = Pattern2.cmpile("\\[\\[[%s]*([^%s%g\\[\\]]+?)(?:[%s]*\\{([^{}]*)\\})?(?:[%s]([^%s\\{\\}\\[\\]][^\\[\\]]*))?[%s]*\\]\\]");
    private final String topurl;
    private UrlMode mode;

    public static String getRegexp() {
        return "\\[\\[[%s]*[%g]([^%g]+)[%g](?:[%s]*\\{([^{}]*)\\})?(?:[%s]([^%s\\{\\}\\[\\]][^\\[\\]]*))?[%s]*\\]\\]|\\[\\[[%s]*\\{(.*)\\}[%s]*\\]\\]|\\[\\[[%s]*\\{([^{}]*)\\}[%s]*([^\\[%s\\{\\}\\[\\]][^\\[\\]]*)[%s]*\\]\\]|\\[\\[[%s]*([^\\s%g{}\\[\\]]+?)[%s]*\\{(.+)\\}[%s]*\\]\\]|\\[\\[[%s]*([^%s%g\\[\\]]+?)(?:[%s]*\\{([^{}]*)\\})?(?:[%s]([^%s\\{\\}\\[\\]][^\\[\\]]*))?[%s]*\\]\\]";
    }

    public UrlBuilder(String topurl, UrlMode mode) {
        this.topurl = topurl;
        this.mode = mode;
    }

    public Url getUrl(String s) {
        Matcher2 m = QUOTED.matcher(s);
        if (this.matchesOrFind(m)) {
            return new Url(this.withTopUrl(m.group(1)), m.group(2), m.group(3));
        }
        m = ONLY_TOOLTIP.matcher(s);
        if (this.matchesOrFind(m)) {
            return new Url("", m.group(1), null);
        }
        m = ONLY_TOOLTIP_AND_LABEL.matcher(s);
        if (this.matchesOrFind(m)) {
            return new Url("", m.group(1), m.group(2));
        }
        m = LINK_TOOLTIP_NOLABEL.matcher(s);
        if (this.matchesOrFind(m)) {
            return new Url(this.withTopUrl(m.group(1)), m.group(2), null);
        }
        m = LINK_WITH_OPTIONAL_TOOLTIP_WITH_OPTIONAL_LABEL.matcher(s);
        if (this.matchesOrFind(m)) {
            return new Url(this.withTopUrl(m.group(1)), m.group(2), m.group(3));
        }
        return null;
    }

    private boolean matchesOrFind(Matcher2 m) {
        if (this.mode == UrlMode.STRICT) {
            return m.matches();
        }
        if (this.mode == UrlMode.ANYWHERE) {
            return m.find();
        }
        throw new IllegalStateException();
    }

    private String withTopUrl(String url) {
        if (!(url.startsWith("http:") || url.startsWith("https:") || url.startsWith("file:") || this.topurl == null)) {
            return this.topurl + url;
        }
        return url;
    }
}

