/*
 * Decompiled with CFR 0.152.
 */
package de.tuberlin.polymake.common.geometry;

import de.tuberlin.polymake.common.SelectorThread;
import de.tuberlin.polymake.common.SharedMemoryMatrix;
import de.tuberlin.polymake.common.SharedMemoryMatrixException;
import de.tuberlin.polymake.common.geometry.PolymakePoint;

public class PointSet {
    protected String name;
    protected PolymakePoint[] points;
    int dim = 3;
    protected SharedMemoryMatrix smm = null;

    public PointSet() {
        this.name = null;
        this.points = new PolymakePoint[0];
    }

    public PointSet(String string, int n) {
        this.name = string;
        this.points = new PolymakePoint[n];
    }

    public PointSet(PointSet pointSet) {
        this.name = pointSet.getName();
        this.points = pointSet.getPoints();
        this.smm = pointSet.getSMM();
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPoint(int n, PolymakePoint polymakePoint) {
        this.points[n] = polymakePoint;
    }

    public void setPoints(PolymakePoint[] polymakePointArray) {
        if (this.points == null || this.points.length == 0) {
            this.points = new PolymakePoint[polymakePointArray.length];
        }
        System.arraycopy(polymakePointArray, 0, this.points, 0, polymakePointArray.length);
    }

    public void resize(int n, int n2) {
        this.dim = n2;
        this.points = new PolymakePoint[n];
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new PolymakePoint(this.dim);
        }
    }

    public String getName() {
        return this.name;
    }

    public PolymakePoint getPoint(int n) {
        return this.points[n];
    }

    public PolymakePoint[] getPoints() {
        PolymakePoint[] polymakePointArray = new PolymakePoint[this.points.length];
        System.arraycopy(this.points, 0, polymakePointArray, 0, this.points.length);
        return polymakePointArray;
    }

    public int getNPoints() {
        return this.points.length;
    }

    public int getDim() {
        return this.dim;
    }

    public void setDim(int n) {
        this.dim = n;
    }

    public void setPointCoords(int n, double[] dArray) {
        if (this.points[n] == null) {
            this.points[n] = new PolymakePoint(dArray);
        } else {
            this.points[n].setCoords(dArray);
        }
        if (this.smm != null) {
            try {
                this.smm.setCoords(n, this.points[n]);
            }
            catch (SharedMemoryMatrixException sharedMemoryMatrixException) {
                sharedMemoryMatrixException.printStackTrace(SelectorThread.newErr);
            }
        }
    }

    public void setNPoints(int n) {
        PolymakePoint[] polymakePointArray = new PolymakePoint[n];
        System.arraycopy(this.points, 0, polymakePointArray, 0, Math.min(n, this.points.length));
        this.points = polymakePointArray;
    }

    public void setMarkedPoint(int n, boolean bl) {
        this.points[n].setMarked(bl);
    }

    public String toString() {
        Object object = new String();
        object = (String)object + "name:" + this.name + "\npoints:\n";
        for (int i = 0; i < this.points.length; ++i) {
            object = (String)object + "\t" + this.points[i].toString();
        }
        return object;
    }

    public SharedMemoryMatrix getSMM() {
        return this.smm;
    }

    public void initSMM(int n) throws SharedMemoryMatrixException {
        this.smm = new SharedMemoryMatrix(n);
    }

    public void readFromSMM() throws SharedMemoryMatrixException {
        if (this.getNPoints() == 0) {
            this.resize(this.smm.getNPoints(), this.smm.getDim());
        }
        this.smm.copyCoords(this);
    }

    public void writeToSMM() throws SharedMemoryMatrixException {
        this.smm.setCoords(this);
    }
}

