/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.common.ChangeLemma;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.de.AgreementSet;
import ai.grazie.rules.tree.NodePattern;
import java.util.List;
import java.util.Set;

class LemmaChanges {
    static final NodePattern accidentalAuxKonjunktiv = NodePattern.N.lemma("haben|werden").pos(".*PR\u00c4.*");
    static final NodePattern inConditional = NodePattern.N.withDependent("mark", NodePattern.N.form("ob|wenn"));
    private static final NodePattern sameKjPrtFormInConditional = NodePattern.N.onlyPos(".*(KJ|PRT).*").and(inConditional);
    private static final NodePattern leaveKonjunktiv = NodePattern.or(NodePattern.N.withHeadRelation("aux").andNot(accidentalAuxKonjunktiv), NodePattern.not(NodePattern.N.withHeadRelation("aux")).noDependents("aux").pos("VER:3:SIN:KJ1.*").pos("VER:1:SIN:PR\u00c4.*").andNot(CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj.*", NodePattern.N.form("ich")))), sameKjPrtFormInConditional);
    private static final NodePattern infiniteAux = NodePattern.N.markAs("Aux").withHead("aux", NodePattern.N.withDependent("aux", NodePattern.N.before("Aux")));
    private static final NodePattern leaveFinite = NodePattern.not(NodePattern.N.withDependent("aux")).andNot(infiniteAux);
    private static final NodePattern leaveInfinitive = NodePattern.or(NodePattern.N.withDependent("aux"), infiniteAux);
    private static final NodePattern has1SgSubj = CommonPatterns.skipUp("aux", CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj.*", NodePattern.N.form("ich"))));

    LemmaChanges() {
    }

    static ChangeLemma changeSameGenderNounLemma(String toLemma) {
        ChangeLemma.PosGenerator pos = (noun, srcPosTags) -> {
            AgreementSet set = AgreementSet.createRelaxed(noun);
            Set acceptable = set == null ? Set.of() : set.commonFeatures(set.possibleCases.allowed());
            List filteredPos = srcPosTags.stream().filter(p -> {
                if (acceptable.isEmpty()) {
                    return true;
                }
                AgreementSet.InflectedForm form = AgreementSet.InflectedForm.fromPos(p);
                return form == null || acceptable.stream().anyMatch(f -> f.unify(form) != null);
            }).toList();
            List result = !filteredPos.isEmpty() ? filteredPos : srcPosTags;
            return result.stream().map(ChangeLemma.PosMapping::new);
        };
        return ChangeLemma.to(toLemma).withPos(pos);
    }

    static ChangeLemma changeOwnVerbLemma(String toLemma) {
        return ChangeLemma.to(toLemma).withPos((node, srcPosTags) -> {
            boolean removeInfinitive = !leaveInfinitive.matches(node);
            boolean removeFinite = !leaveFinite.matches(node);
            boolean removeKonjunktiv = !leaveKonjunktiv.matches(node);
            boolean removePraeteritum = sameKjPrtFormInConditional.matches(node);
            boolean prefer1Sg = has1SgSubj.matches(node);
            return srcPosTags.stream().map(pos -> {
                if (pos.matches("VER:(MOD:)?[12]:PLU.*") || pos.matches("VER:(MOD:)?1:SIN.*") && !prefer1Sg || pos.matches("VER:(MOD:)?3:SIN.*") && prefer1Sg || pos.matches(".*AUX:[123].*") || pos.contains("IMP") || removeKonjunktiv && pos.contains("KJ") || removeInfinitive && pos.contains("INF") || removePraeteritum && pos.contains("PRT") || removeFinite && pos.matches("VER:(AUX:)?3.*")) {
                    return null;
                }
                if (pos.matches(".*(SFT|NON)")) {
                    return new ChangeLemma.PosMapping((String)pos, pos.substring(0, pos.length() - 3) + ".*");
                }
                pos = pos.replaceAll("(VER.*)NON(:NEB)?", "$1SFT").replaceAll("(VER.*)(SFT)(:NEB)?", "$1NON").replaceAll("VER:MOD(.*)", "VER(:MOD)?$1(:NON)?(:SFT)?(:NEB)?");
                return new ChangeLemma.PosMapping((String)pos);
            });
        });
    }
}

