#if !defined(TORCH_STABLE_ONLY) && !defined(TORCH_TARGET_VERSION)
#pragma once

// @generated by torchgen/gen.py from Function.h

#include <ATen/Context.h>
#include <ATen/DeviceGuard.h>
#include <ATen/TensorUtils.h>
#include <ATen/TracerMode.h>
#include <ATen/core/Generator.h>
#include <ATen/core/Reduction.h>
#include <ATen/core/Tensor.h>
#include <c10/core/Scalar.h>
#include <c10/core/Storage.h>
#include <c10/core/TensorOptions.h>
#include <c10/util/Deprecated.h>
#include <optional>
#include <string_view>



#include <ATen/ops/max_ops.h>

namespace at {


// aten::max.dim(Tensor self, int dim, bool keepdim=False) -> (Tensor values, Tensor indices)
inline ::std::tuple<at::Tensor,at::Tensor> max(const at::Tensor & self, int64_t dim, bool keepdim=false) {
    return at::_ops::max_dim::call(self, dim, keepdim);
}

// aten::max.dim_max(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) max, Tensor(b!) max_values) -> (Tensor(a!) values, Tensor(b!) indices)
inline ::std::tuple<at::Tensor &,at::Tensor &> max_out(at::Tensor & max, at::Tensor & max_values, const at::Tensor & self, int64_t dim, bool keepdim=false) {
    return at::_ops::max_dim_max::call(self, dim, keepdim, max, max_values);
}
// aten::max.dim_max(Tensor self, int dim, bool keepdim=False, *, Tensor(a!) max, Tensor(b!) max_values) -> (Tensor(a!) values, Tensor(b!) indices)
inline ::std::tuple<at::Tensor &,at::Tensor &> max_outf(const at::Tensor & self, int64_t dim, bool keepdim, at::Tensor & max, at::Tensor & max_values) {
    return at::_ops::max_dim_max::call(self, dim, keepdim, max, max_values);
}

// aten::max.names_dim(Tensor self, Dimname dim, bool keepdim=False) -> (Tensor values, Tensor indices)
inline ::std::tuple<at::Tensor,at::Tensor> max(const at::Tensor & self, at::Dimname dim, bool keepdim=false) {
    return at::_ops::max_names_dim::call(self, dim, keepdim);
}

// aten::max.names_dim_max(Tensor self, Dimname dim, bool keepdim=False, *, Tensor(a!) max, Tensor(b!) max_values) -> (Tensor(a!) values, Tensor(b!) indices)
inline ::std::tuple<at::Tensor &,at::Tensor &> max_out(at::Tensor & max, at::Tensor & max_values, const at::Tensor & self, at::Dimname dim, bool keepdim=false) {
    return at::_ops::max_names_dim_max::call(self, dim, keepdim, max, max_values);
}
// aten::max.names_dim_max(Tensor self, Dimname dim, bool keepdim=False, *, Tensor(a!) max, Tensor(b!) max_values) -> (Tensor(a!) values, Tensor(b!) indices)
inline ::std::tuple<at::Tensor &,at::Tensor &> max_outf(const at::Tensor & self, at::Dimname dim, bool keepdim, at::Tensor & max, at::Tensor & max_values) {
    return at::_ops::max_names_dim_max::call(self, dim, keepdim, max, max_values);
}

// aten::max(Tensor self) -> Tensor
inline at::Tensor max(const at::Tensor & self) {
    return at::_ops::max::call(self);
}

// aten::max.other(Tensor self, Tensor other) -> Tensor
inline at::Tensor max(const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::max_other::call(self, other);
}

// aten::max.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
inline at::Tensor & max_out(at::Tensor & out, const at::Tensor & self, const at::Tensor & other) {
    return at::_ops::max_out::call(self, other, out);
}
// aten::max.out(Tensor self, Tensor other, *, Tensor(a!) out) -> Tensor(a!)
inline at::Tensor & max_outf(const at::Tensor & self, const at::Tensor & other, at::Tensor & out) {
    return at::_ops::max_out::call(self, other, out);
}

// aten::max.unary_out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
inline at::Tensor & max_out(at::Tensor & out, const at::Tensor & self) {
    return at::_ops::max_unary_out::call(self, out);
}
// aten::max.unary_out(Tensor self, *, Tensor(a!) out) -> Tensor(a!)
inline at::Tensor & max_outf(const at::Tensor & self, at::Tensor & out) {
    return at::_ops::max_unary_out::call(self, out);
}

}

#else
#error "This file should not be included when either TORCH_STABLE_ONLY or TORCH_TARGET_VERSION is defined."
#endif  // !defined(TORCH_STABLE_ONLY) && !defined(TORCH_TARGET_VERSION)
