;; Copyright (c) 2009 Derick Eddington.
;;
;; Permission is hereby granted, free of charge, to any person obtaining a
;; copy of this software and associated documentation files (the "Software"),
;; to deal in the Software without restriction, including without limitation
;; the rights to use, copy, modify, merge, publish, distribute, sublicense,
;; and/or sell copies of the Software, and to permit persons to whom the
;; Software is furnished to do so, subject to the following conditions:

;; The above copyright notice and this permission notice shall be included in
;; all copies or substantial portions of the Software.

;; Except as contained in this notice, the name(s) of the above copyright
;; holders shall not be used in advertising or otherwise to promote the sale,
;; use or other dealings in this Software without prior written authorization.

;; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
;; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
;; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
;; THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
;; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
;; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
;; DEALINGS IN THE SOFTWARE.

#!r6rs
(library (srfi :6)
  (export
    (rename (open-string-input-port open-input-string))
    open-output-string
    get-output-string)
  (import
    (rnrs)
    (only (scheme base) make-weak-hasheq hash-ref hash-set!))
  
  (define accumed-ht (make-weak-hasheq))
  
  (define (open-output-string)
    (letrec ([sop
              (make-custom-textual-output-port
               "string-output-port"
               (lambda (string start count)  ; write!
                 (when (positive? count)
                   (let ([al (hash-ref accumed-ht sop)])
                     (hash-set! accumed-ht sop 
                       (cons (substring string start (+ start count)) al))))
                 count)
               #f  ; get-position  TODO?
               #f  ; set-position!  TODO?
               #f  #| closed  TODO? |# )])
      (hash-set! accumed-ht sop '())
      sop))
  
  (define (get-output-string sop)
    (if (output-port? sop)
      (cond [(hash-ref accumed-ht sop #f)
             => (lambda (al) (apply string-append (reverse al)))]
            [else
             (assertion-violation 'get-output-string "not a string-output-port" sop)])
      (assertion-violation 'get-output-string "not an output-port" sop)))

)
