/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generatePdqXml;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.db.SqlStatementKey;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlCaptureStatistics;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlSpecialRegValuesSet;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatement;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementAttributes;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementDescriptor;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementMetadata;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.generatePdqXml.DynamicStatementCache;
import com.ibm.db2.cmx.tools.internal.generatePdqXml.PDQXmlStatementForGeneratePureQueryXml;
import com.ibm.db2.cmx.tools.internal.generatePdqXml.QueryTunerXMLFile;
import com.ibm.db2.cmx.tools.internal.generatePdqXml.SQLScriptFile;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public abstract class SQLFile {
    public static final String inputExtensionSQLScriptFileLowerCase = ".sql";
    public static final String inputExtensionOQWTFileLowerCase = ".xml";
    public static final String[] inputExtensionsLowerCase = new String[]{".sql", ".xml"};
    final PDQXmlSpecialRegValuesSet specialRegisterValuesSetsOriginElement_;
    final int resultSetType_;
    final int resultSetConcurrency_;
    final int resultSetHoldability_;
    final String inputSQLFilePath_;
    final SqlStatementKey defaultStatementAttributesForInputSQLFile_;
    protected boolean hasParseMethodCompleted_ = false;

    static SQLFile getSQLFile(ArtifactOptionsSet artifactOptionsSet, String string, PDQXmlSpecialRegValuesSet pDQXmlSpecialRegValuesSet) {
        if (null != string) {
            String string2 = string.trim().toLowerCase();
            String string3 = null;
            if (PossibleArgs.PredefinedOptionValues.INPUT_SQL_DYNAMIC_STATEMENT_CACHE.getOptionValue().toLowerCase().equals(string2)) {
                if (artifactOptionsSet.isOptionOrArtifactSpecified(PossibleArgs.RESULTSET_TYPE)) {
                    string3 = PossibleArgs.RESULTSET_TYPE.toString();
                } else if (artifactOptionsSet.isOptionOrArtifactSpecified(PossibleArgs.RESULTSET_CONCURRENCY)) {
                    string3 = PossibleArgs.RESULTSET_CONCURRENCY.toString();
                } else if (artifactOptionsSet.isOptionOrArtifactSpecified(PossibleArgs.RESULTSET_HOLDABILITY)) {
                    string3 = PossibleArgs.RESULTSET_HOLDABILITY.toString();
                }
                if (string3 != null) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_DSC_INVALID_OPTION_COMBINATION", string3), null, 11749);
                }
                return new DynamicStatementCache(artifactOptionsSet, string, pDQXmlSpecialRegValuesSet);
            }
            if (string2.endsWith(inputExtensionSQLScriptFileLowerCase)) {
                return new SQLScriptFile(artifactOptionsSet, string, pDQXmlSpecialRegValuesSet);
            }
            if (string2.endsWith(inputExtensionOQWTFileLowerCase)) {
                return new QueryTunerXMLFile(artifactOptionsSet, string, pDQXmlSpecialRegValuesSet);
            }
        }
        throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_FILE_EXTENSION_UNSUPPORTED", new Object[]{string, PossibleArgs.INPUT_SQL, Messages.getListOfValues(true, inputExtensionsLowerCase)}), null, 11175);
    }

    protected SQLFile(ArtifactOptionsSet artifactOptionsSet, String string, PDQXmlSpecialRegValuesSet pDQXmlSpecialRegValuesSet) {
        this.inputSQLFilePath_ = string;
        this.specialRegisterValuesSetsOriginElement_ = pDQXmlSpecialRegValuesSet;
        this.resultSetType_ = XmlTags.getCursorAttributeNumber(artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.RESULTSET_TYPE));
        this.resultSetConcurrency_ = XmlTags.getCursorAttributeNumber(artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.RESULTSET_CONCURRENCY));
        this.resultSetHoldability_ = XmlTags.getCursorAttributeNumber(artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.RESULTSET_HOLDABILITY));
        this.defaultStatementAttributesForInputSQLFile_ = SqlStatementKey.generateStmtKey("", this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, null, null, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<PDQXmlStatementForGeneratePureQueryXml> parseFileAndReturnStatementList(Connection connection) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            Object object;
            Object object2;
            if (!PossibleArgs.PredefinedOptionValues.INPUT_SQL_DYNAMIC_STATEMENT_CACHE.getOptionValue().equalsIgnoreCase(this.inputSQLFilePath_)) {
                object2 = this.guessEncodingFromBOM(this.inputSQLFilePath_);
                object = new FileInputStream(this.inputSQLFilePath_);
                if (object2 == null) {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                } else {
                    ToolsLogger.getLogger().log(Level.FINEST, "Input file encoding is " + (String)object2);
                    if (((String)object2).equals("UTF-8")) {
                        for (int i10 = 0; i10 < 3; ++i10) {
                            ((InputStream)object).read();
                        }
                    }
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object, (String)object2));
                }
            }
            object2 = this.parseFileAndReturnStatementList(connection, bufferedReader);
            this.hasParseMethodCompleted_ = true;
            object = object2;
            return object;
        }
        finally {
            try {
                if (null != bufferedReader) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    abstract List<PDQXmlStatementForGeneratePureQueryXml> parseFileAndReturnStatementList(Connection var1, BufferedReader var2) throws IOException;

    public SqlStatementKey getDefaultStatementAttributesForInputSQLFile() {
        return this.defaultStatementAttributesForInputSQLFile_;
    }

    public abstract boolean statementAttributesVary();

    protected boolean doStatementAttributesDifferFromDefaults(PDQXmlStatementDescriptor pDQXmlStatementDescriptor) {
        PDQXmlStatementAttributes pDQXmlStatementAttributes = pDQXmlStatementDescriptor.getStatementAttributes();
        if (pDQXmlStatementAttributes.getType() != this.resultSetType_) {
            return true;
        }
        if (pDQXmlStatementAttributes.getConcurrency() != this.resultSetConcurrency_) {
            return true;
        }
        if (pDQXmlStatementAttributes.getHoldability() != this.resultSetHoldability_) {
            return true;
        }
        if (!Arrays.equals(pDQXmlStatementDescriptor.getAutogenColumnNames(), this.defaultStatementAttributesForInputSQLFile_.autoGenKeyColNames_)) {
            return true;
        }
        if (!Arrays.equals(pDQXmlStatementDescriptor.getAutogenColumnIndexes(), this.defaultStatementAttributesForInputSQLFile_.autoGenKeyColIndexes_)) {
            return true;
        }
        return pDQXmlStatementDescriptor.getAutogenColumnIndicator() != this.defaultStatementAttributesForInputSQLFile_.autoGenKeyIndicator_;
    }

    protected PDQXmlStatementDescriptor getStatementDescriptor(PDQXmlStatement pDQXmlStatement) {
        return this.getStatementDescriptor(pDQXmlStatement, null);
    }

    protected PDQXmlStatementDescriptor getStatementDescriptor(PDQXmlStatement pDQXmlStatement, PDQXmlStatementAttributes pDQXmlStatementAttributes) {
        if (null == pDQXmlStatement) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", pDQXmlStatement), null, 11176);
        }
        PDQXmlStatementDescriptor pDQXmlStatementDescriptor = pDQXmlStatement.getPDQXmlStatementDescriptor();
        if (null == pDQXmlStatementDescriptor) {
            pDQXmlStatementDescriptor = new PDQXmlStatementDescriptor();
            if (null == pDQXmlStatementAttributes) {
                pDQXmlStatementAttributes = this.createPDQXmlStatementAttributesWithDefaultAttributesForFile();
            }
            pDQXmlStatementDescriptor.setStatementAttributes(pDQXmlStatementAttributes);
            pDQXmlStatement.setPDQXmlStatementDescriptor(pDQXmlStatementDescriptor);
        }
        return pDQXmlStatementDescriptor;
    }

    protected PDQXmlStatementAttributes getStatementAttributes(PDQXmlStatement pDQXmlStatement) {
        if (null == pDQXmlStatement) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", pDQXmlStatement), null, 11199);
        }
        PDQXmlStatementDescriptor pDQXmlStatementDescriptor = this.getStatementDescriptor(pDQXmlStatement);
        return pDQXmlStatementDescriptor.getStatementAttributes();
    }

    protected static PDQXmlStatementMetadata getStatementMetadata(PDQXmlStatement pDQXmlStatement) {
        if (null == pDQXmlStatement) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", pDQXmlStatement), null, 11178);
        }
        PDQXmlStatementMetadata pDQXmlStatementMetadata = pDQXmlStatement.getPDQXmlStatementMetadata();
        if (null == pDQXmlStatementMetadata) {
            pDQXmlStatementMetadata = new PDQXmlStatementMetadata();
            pDQXmlStatement.setPDQXmlStatementMetadata(pDQXmlStatementMetadata);
        }
        return pDQXmlStatementMetadata;
    }

    protected static PDQXmlCaptureStatistics getCaptureStatistics(PDQXmlStatement pDQXmlStatement) {
        PDQXmlStatementMetadata pDQXmlStatementMetadata = SQLFile.getStatementMetadata(pDQXmlStatement);
        PDQXmlCaptureStatistics pDQXmlCaptureStatistics = pDQXmlStatementMetadata.getPDQXmlCaptureStatistics();
        if (null == pDQXmlCaptureStatistics) {
            pDQXmlCaptureStatistics = new PDQXmlCaptureStatistics();
            pDQXmlStatementMetadata.setPDQXmlCaptureStatistics(pDQXmlCaptureStatistics);
        }
        return pDQXmlCaptureStatistics;
    }

    protected PDQXmlStatementAttributes createPDQXmlStatementAttributesWithDefaultAttributesForFile() {
        PDQXmlStatementAttributes pDQXmlStatementAttributes = PDQXmlStatementAttributes.getPDQXmlStatementAttributesForClientOptimizer();
        pDQXmlStatementAttributes.setHoldability(this.resultSetHoldability_);
        pDQXmlStatementAttributes.setConcurrency(this.resultSetConcurrency_);
        pDQXmlStatementAttributes.setType(this.resultSetType_);
        return pDQXmlStatementAttributes;
    }

    private String guessEncodingFromBOM(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[4];
        int n2 = fileInputStream.read(byArray);
        fileInputStream.close();
        if (n2 > -1) {
            if ((byArray[0] & 0xFF) == 239 && (byArray[1] & 0xFF) == 187 && (byArray[2] & 0xFF) == 191) {
                return "UTF-8";
            }
            if ((byArray[0] & 0xFF) == 254 && (byArray[1] & 0xFF) == 255) {
                return "UTF-16";
            }
            if ((byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 254) {
                return "UTF-16";
            }
            if ((byArray[0] & 0xFF) == 132 && (byArray[1] & 0xFF) == 49 && (byArray[2] & 0xFF) == 149 && (byArray[3] & 0xFF) == 51) {
                return "GB18030";
            }
        }
        return null;
    }

    protected void throwExceptionIfParseMethodHasNotCompleted(String string, String string2) {
        if (!this.hasParseMethodCompleted_) {
            String string3 = Messages.getText("ERR_METHOD_CALLED_OUT_OF_ORDER", string, this.getClass().getCanonicalName());
            if (StaticProfileConstants.isValueSet(string2)) {
                string3 = string3 + "  " + string2;
            }
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(string2, null, 11160);
        }
    }
}

