/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.carrot2.attrs.AttrString;
import org.carrot2.clustering.Cluster;
import org.carrot2.clustering.Document;

public class SharedInfrastructure {
    public static AttrString queryHintAttribute() {
        return AttrString.builder().label("Query hint").defaultValue(null);
    }

    public static <T> List<Cluster<T>> reorderByWeightedScoreAndSize(List<Cluster<T>> clusters, double scoreWeight) {
        Comparator<ClusterData> comparator = Comparator.comparingDouble(data -> data.score).reversed().thenComparing(Comparator.nullsFirst(Comparator.comparing(data -> data.label)));
        return clusters.stream().map(cluster -> {
            int docCount = SharedInfrastructure.recursiveDocumentCount(cluster);
            double score = Math.pow(docCount, 1.0 - scoreWeight) * Math.pow(cluster.getScore(), scoreWeight);
            return new ClusterData(cluster, score, docCount);
        }).sorted(comparator).map(data -> data.cluster).collect(Collectors.toList());
    }

    public static <T extends Document> List<Cluster<T>> reorderByDescendingSizeAndLabel(ArrayList<Cluster<T>> clusters) {
        Comparator<ClusterData> comparator = Comparator.comparingInt(data -> data.recursiveDocumentCount).reversed().thenComparing(Comparator.nullsFirst(Comparator.comparing(data -> data.label)));
        return clusters.stream().map(cluster -> {
            int docCount = SharedInfrastructure.recursiveDocumentCount(cluster);
            return new ClusterData(cluster, 0.0, docCount);
        }).sorted(comparator).map(data -> data.cluster).collect(Collectors.toList());
    }

    public static int recursiveDocumentCount(Cluster<?> cluster) {
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        ArrayDeque queue = new ArrayDeque();
        queue.add(cluster);
        while (!queue.isEmpty()) {
            Cluster c = (Cluster)queue.removeLast();
            visited.addAll(c.getDocuments());
            queue.addAll(cluster.getClusters());
        }
        return visited.size();
    }

    private static class ClusterData<T> {
        final Cluster<T> cluster;
        final double score;
        final String label;
        final int recursiveDocumentCount;

        public ClusterData(Cluster<T> cluster, double score, int recursiveDocumentCount) {
            this.cluster = cluster;
            this.label = String.join((CharSequence)", ", cluster.getLabels());
            this.score = score;
            this.recursiveDocumentCount = recursiveDocumentCount;
        }
    }
}

