/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.types;

import com.j256.simplemagic.endian.EndianType;
import com.j256.simplemagic.types.NumberType;

public class DoubleType
extends NumberType {
    private static final int BYTES_PER_DOUBLE = 8;

    public DoubleType(EndianType endianType) {
        super(endianType);
    }

    @Override
    public Number decodeValueString(String valueStr) throws NumberFormatException {
        return Double.parseDouble(valueStr);
    }

    @Override
    public Object extractValueFromBytes(int offset, byte[] bytes, boolean required) {
        Long val = this.endianConverter.convertNumber(offset, bytes, this.getBytesPerType());
        if (val == null) {
            return null;
        }
        return this.longToObject(val);
    }

    @Override
    public int compare(boolean unsignedType, Number extractedValue, Number testValue) {
        double testDouble;
        double extractedDouble = extractedValue.doubleValue();
        if (extractedDouble > (testDouble = testValue.doubleValue())) {
            return 1;
        }
        if (extractedDouble < testDouble) {
            return -1;
        }
        return 0;
    }

    @Override
    public byte[] getStartingBytes(Object testValue) {
        return null;
    }

    protected Object longToObject(Long value) {
        return Double.longBitsToDouble(value);
    }

    @Override
    public long maskValue(long value) {
        return value;
    }

    @Override
    public int getBytesPerType() {
        return 8;
    }
}

