/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.ConfigSetProperties;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.FileTypeMagicUtil;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkConfigSetService
extends ConfigSetService {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ZkController zkController;
    private final SolrZkClient zkClient;
    public static final String CONFIGS_ZKNODE = "/configs";

    public ZkConfigSetService(CoreContainer cc) {
        super(cc.getResourceLoader(), cc.getConfig().hasSchemaCache());
        this.zkController = cc.getZkController();
        this.zkClient = cc.getZkController().getZkClient();
    }

    public ZkConfigSetService(SolrZkClient zkClient) {
        super(null, false);
        this.zkController = null;
        this.zkClient = zkClient;
    }

    @Override
    public SolrResourceLoader createCoreResourceLoader(CoreDescriptor cd) {
        if (cd.getConfigSet() == null) {
            String configSetName = this.zkController.getClusterState().getCollection(cd.getCollectionName()).getConfigName();
            cd.setConfigSet(configSetName);
        }
        return new ZkSolrResourceLoader(cd.getInstanceDir(), cd.getConfigSet(), this.parentLoader.getClassLoader(), this.zkController);
    }

    @Override
    protected NamedList<Object> loadConfigSetFlags(SolrResourceLoader loader) throws IOException {
        try {
            return ConfigSetProperties.readFromResourceLoader(loader, ".");
        }
        catch (Exception ex) {
            log.debug("No configSet flags", (Throwable)ex);
            return null;
        }
    }

    @Override
    protected Long getCurrentSchemaModificationVersion(String configSet, SolrConfig solrConfig, String schemaFile) throws IOException {
        Stat stat;
        String zkPath = "/configs/" + configSet + "/" + schemaFile;
        try {
            stat = this.zkClient.exists(zkPath, null, true);
        }
        catch (KeeperException e) {
            log.warn("Unexpected exception when getting modification time of {}", (Object)zkPath, (Object)e);
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        if (stat == null) {
            return null;
        }
        return stat.getVersion();
    }

    @Override
    public String configSetName(CoreDescriptor cd) {
        return "configset " + cd.getConfigSet();
    }

    @Override
    public boolean checkConfigExists(String configName) throws IOException {
        try {
            return this.zkClient.exists("/configs/" + configName, true);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error checking whether config exists", SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    @Override
    public void deleteConfig(String configName) throws IOException {
        try {
            this.zkClient.clean("/configs/" + configName);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error deleting config", SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    @Override
    public void deleteFilesFromConfig(String configName, List<String> filesToDelete) throws IOException {
        Objects.requireNonNull(filesToDelete);
        try {
            for (String fileToDelete : filesToDelete) {
                if (fileToDelete.endsWith("/")) {
                    fileToDelete = fileToDelete.substring(0, fileToDelete.length() - 1);
                }
                this.zkClient.clean("/configs/" + configName + "/" + fileToDelete);
            }
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error deleting files in config", SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    @Override
    public void copyConfig(String fromConfig, String toConfig) throws IOException {
        String fromConfigPath = "/configs/" + fromConfig;
        String toConfigPath = "/configs/" + toConfig;
        try {
            this.copyData(fromConfigPath, toConfigPath);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error config " + fromConfig + " to " + toConfig, SolrZkClient.checkInterrupted((Throwable)e));
        }
        this.copyConfigDirFromZk(fromConfigPath, toConfigPath);
    }

    @Override
    protected void uploadConfig(String configName, Path dir) throws IOException {
        this.zkClient.uploadToZK(dir, "/configs/" + configName, ConfigSetService.UPLOAD_FILENAME_EXCLUDE_PATTERN);
    }

    @Override
    public void uploadFileToConfig(String configName, String fileName, byte[] data, boolean overwriteOnExists) throws IOException {
        String filePath = "/configs/" + configName + "/" + fileName;
        try {
            if (ZkMaintenanceUtils.isFileForbiddenInConfigSets((String)fileName)) {
                log.warn("Not including uploading file to config, as it is a forbidden type: {}", (Object)fileName);
            } else {
                if (FileTypeMagicUtil.isFileForbiddenInConfigset(data)) {
                    String mimeType = FileTypeMagicUtil.INSTANCE.guessMimeType(data);
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Not uploading file %s to config, as it matched the MAGIC signature of a forbidden mime type %s", fileName, mimeType));
                }
                this.zkClient.makePath(filePath, data, CreateMode.PERSISTENT, null, !overwriteOnExists, true);
            }
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The path " + filePath + " for configSet " + configName + " already exists. In order to overwrite, provide overwrite=true or use an HTTP PUT with the V2 API.");
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error creating file in config", SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    @Override
    public void setConfigMetadata(String configName, Map<String, Object> data) throws IOException {
        try {
            this.zkClient.makePath("/configs/" + configName, Utils.toJSON(data), CreateMode.PERSISTENT, null, false, true);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error setting config metadata", SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    @Override
    public Map<String, Object> getConfigMetadata(String configName) throws IOException {
        try {
            Map data = (Map)Utils.fromJSON((byte[])this.zkClient.getData("/configs/" + configName, null, null, true));
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            return Collections.emptyMap();
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error getting config metadata", SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    @Override
    public void downloadConfig(String configName, Path dir) throws IOException {
        this.zkClient.downloadFromZK("/configs/" + configName, dir);
    }

    @Override
    public byte[] downloadFileFromConfig(String configName, String filePath) throws IOException {
        try {
            return this.zkClient.getData("/configs/" + configName + "/" + filePath, null, null, true);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error downloading file from config", SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    @Override
    public List<String> listConfigs() throws IOException {
        try {
            return this.zkClient.getChildren(CONFIGS_ZKNODE, null, true);
        }
        catch (KeeperException.NoNodeException e) {
            return Collections.emptyList();
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error listing configs", SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    @Override
    public List<String> getAllConfigFiles(String configName) throws IOException {
        String zkPath = "/configs/" + configName;
        try {
            ArrayList<String> filePaths = new ArrayList<String>();
            ZkMaintenanceUtils.traverseZkTree((SolrZkClient)this.zkClient, (String)zkPath, (ZkMaintenanceUtils.VISIT_ORDER)ZkMaintenanceUtils.VISIT_ORDER.VISIT_POST, filePaths::add);
            filePaths.remove(zkPath);
            String prevPath = "";
            for (int i = 0; i < filePaths.size(); ++i) {
                Object currPath = (String)filePaths.get(i);
                assert (((String)currPath).startsWith(zkPath + "/"));
                if (prevPath.startsWith((String)(currPath = ((String)currPath).substring(zkPath.length() + 1)))) {
                    currPath = (String)currPath + "/";
                }
                prevPath = currPath;
                filePaths.set(i, (String)currPath);
            }
            Collections.sort(filePaths);
            return filePaths;
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error getting all configset files", SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    private void copyConfigDirFromZk(String fromZkPath, String toZkPath) throws IOException {
        try {
            List files = this.zkClient.getChildren(fromZkPath, null, true);
            for (String file : files) {
                List children = this.zkClient.getChildren(fromZkPath + "/" + file, null, true);
                if (children.size() == 0) {
                    this.copyData(fromZkPath + "/" + file, toZkPath + "/" + file);
                    continue;
                }
                this.copyConfigDirFromZk(fromZkPath + "/" + file, toZkPath + "/" + file);
            }
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error copying nodes from zookeeper path " + fromZkPath + " to " + toZkPath, SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    private void copyData(String fromZkFilePath, String toZkFilePath) throws KeeperException, InterruptedException {
        if (ZkMaintenanceUtils.isFileForbiddenInConfigSets((String)fromZkFilePath)) {
            log.warn("Skipping copy of file in ZK, as the source file is a forbidden type: {}", (Object)fromZkFilePath);
        } else if (ZkMaintenanceUtils.isFileForbiddenInConfigSets((String)toZkFilePath)) {
            log.warn("Skipping download of file from ZK, as the target file is a forbidden type: {}", (Object)toZkFilePath);
        } else {
            log.debug("Copying zk node {} to {}", (Object)fromZkFilePath, (Object)toZkFilePath);
            byte[] data = this.zkClient.getData(fromZkFilePath, null, null, true);
            if (!FileTypeMagicUtil.isFileForbiddenInConfigset(data)) {
                this.zkClient.makePath(toZkFilePath, data, true);
            } else {
                String mimeType = FileTypeMagicUtil.INSTANCE.guessMimeType(data);
                log.warn("Skipping copy of file {} in ZK, as it matched the MAGIC signature of a forbidden mime type {}", (Object)fromZkFilePath, (Object)mimeType);
            }
        }
    }

    public SolrCloudManager getSolrCloudManager() {
        return this.zkController.getSolrCloudManager();
    }
}

