/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.JSONWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.ReturnFields;

class PHPSerializedWriter
extends JSONWriter {
    byte[] utf8 = BytesRef.EMPTY_BYTES;

    public PHPSerializedWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(writer, req, rsp);
        this.doIndent = false;
    }

    @Override
    public void writeResponse() throws IOException {
        Boolean omitHeader = this.req.getParams().getBool("omitHeader");
        if (omitHeader != null && omitHeader.booleanValue()) {
            this.rsp.removeResponseHeader();
        }
        this.writeNamedList(null, this.rsp.getValues());
    }

    public void writeNamedList(String name, NamedList<?> val) throws IOException {
        this.writeNamedListAsMapMangled(name, val);
    }

    @Override
    public void writeStartDocumentList(String name, long start, int size, long numFound, Float maxScore, Boolean numFoundExact) throws IOException {
        this.writeMapOpener(this.headerSize(maxScore, numFoundExact));
        this.writeKey("numFound", false);
        this.writeLong(null, numFound);
        this.writeKey("start", false);
        this.writeLong(null, start);
        if (maxScore != null) {
            this.writeKey("maxScore", false);
            this.writeFloat(null, maxScore.floatValue());
        }
        if (numFoundExact != null) {
            this.writeKey("numFoundExact", false);
            this.writeBool(null, numFoundExact);
        }
        this.writeKey("docs", false);
        this.writeArrayOpener(size);
    }

    @Override
    public void writeEndDocumentList() throws IOException {
        this.writeArrayCloser();
        this.writeMapCloser();
    }

    @Override
    public void writeSolrDocument(String name, SolrDocument doc, ReturnFields returnFields, int idx) throws IOException {
        Object val;
        String fname;
        this.writeKey(idx, false);
        LinkedHashMap<String, Object> single = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> multi = new LinkedHashMap<String, Object>();
        for (String string : doc.getFieldNames()) {
            if (returnFields != null && !returnFields.wantsField(string)) continue;
            Object val2 = doc.getFieldValue(string);
            if (val2 instanceof Collection) {
                multi.put(string, val2);
                continue;
            }
            single.put(string, val2);
        }
        this.writeMapOpener(single.size() + multi.size());
        for (Map.Entry entry : single.entrySet()) {
            fname = (String)entry.getKey();
            val = entry.getValue();
            this.writeKey(fname, true);
            this.writeVal(fname, val);
        }
        for (Map.Entry entry : multi.entrySet()) {
            fname = (String)entry.getKey();
            this.writeKey(fname, true);
            val = entry.getValue();
            if (!(val instanceof Collection)) {
                this.writeArrayOpener(1);
                this.writeVal(fname, val);
                this.writeArrayCloser();
                continue;
            }
            this.writeVal(fname, val);
        }
        this.writeMapCloser();
    }

    public void writeArray(String name, Object[] val, boolean raw) throws IOException {
        assert (!raw);
        this.writeMapOpener(val.length);
        for (int i = 0; i < val.length; ++i) {
            this.writeKey(i, false);
            this.writeVal(String.valueOf(i), val[i]);
        }
        this.writeMapCloser();
    }

    public void writeArray(String name, Iterator<?> val, boolean raw) throws IOException {
        assert (!raw);
        ArrayList vals = new ArrayList();
        while (val.hasNext()) {
            vals.add(val.next());
        }
        this.writeArray(name, vals.toArray(), false);
    }

    public void writeMapOpener(int size) throws IOException, IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("Map size must not be negative");
        }
        this.writer.write("a:" + size + ":{");
    }

    public void writeMapSeparator() throws IOException {
    }

    public void writeMapCloser() throws IOException {
        this.writer.write('}');
    }

    public void writeArrayOpener(int size) throws IOException, IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("Array size must not be negative");
        }
        this.writer.write("a:" + size + ":{");
    }

    public void writeArraySeparator() throws IOException {
    }

    public void writeArrayCloser() throws IOException {
        this.writer.write('}');
    }

    public void writeNull(String name) throws IOException {
        this.writer.write("N;");
    }

    public void writeKey(String fname, boolean needsEscaping) throws IOException {
        this.writeStr(null, fname, needsEscaping);
    }

    void writeKey(int val, boolean needsEscaping) throws IOException {
        this.writeInt(null, String.valueOf(val));
    }

    public void writeBool(String name, boolean val) throws IOException {
        this.writer.write(val ? "b:1;" : "b:0;");
    }

    public void writeBool(String name, String val) throws IOException {
        this.writeBool(name, val.charAt(0) == 't');
    }

    public void writeInt(String name, String val) throws IOException {
        this.writer.write("i:" + val + ";");
    }

    public void writeLong(String name, String val) throws IOException {
        this.writeInt(name, val);
    }

    public void writeFloat(String name, String val) throws IOException {
        this.writeDouble(name, val);
    }

    public void writeDouble(String name, String val) throws IOException {
        this.writer.write("d:" + val + ";");
    }

    public void writeStr(String name, String val, boolean needsEscaping) throws IOException {
        this.utf8 = ArrayUtil.grow((byte[])this.utf8, (int)(val.length() * 3));
        int nBytes = UnicodeUtil.UTF16toUTF8((CharSequence)val, (int)0, (int)val.length(), (byte[])this.utf8);
        this.writer.write("s:");
        this.writer.write(Integer.toString(nBytes));
        this.writer.write(":\"");
        this.writer.write(val);
        this.writer.write("\";");
    }
}

