/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.ASCII85Filter;
import org.apache.pdfbox.filter.ASCIIHexFilter;
import org.apache.pdfbox.filter.CCITTFaxDecodeFilter;
import org.apache.pdfbox.filter.CryptFilter;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.FlateFilter;
import org.apache.pdfbox.filter.JBIG2Filter;
import org.apache.pdfbox.filter.JPXFilter;
import org.apache.pdfbox.filter.LZWFilter;
import org.apache.pdfbox.filter.RunLengthDecodeFilter;

public class FilterManager {
    private final Map<COSName, Filter> filters = new HashMap<COSName, Filter>();

    public FilterManager() {
        FlateFilter flateFilter = new FlateFilter();
        CCITTFaxDecodeFilter ccittFaxFilter = new CCITTFaxDecodeFilter();
        LZWFilter lzwFilter = new LZWFilter();
        ASCIIHexFilter asciiHexFilter = new ASCIIHexFilter();
        ASCII85Filter ascii85Filter = new ASCII85Filter();
        RunLengthDecodeFilter runLengthFilter = new RunLengthDecodeFilter();
        CryptFilter cryptFilter = new CryptFilter();
        JPXFilter jpxFilter = new JPXFilter();
        JBIG2Filter jbig2Filter = new JBIG2Filter();
        this.addFilter(COSName.FLATE_DECODE, flateFilter);
        this.addFilter(COSName.FLATE_DECODE_ABBREVIATION, flateFilter);
        this.addFilter(COSName.DCT_DECODE, jpxFilter);
        this.addFilter(COSName.DCT_DECODE_ABBREVIATION, jpxFilter);
        this.addFilter(COSName.CCITTFAX_DECODE, ccittFaxFilter);
        this.addFilter(COSName.CCITTFAX_DECODE_ABBREVIATION, ccittFaxFilter);
        this.addFilter(COSName.LZW_DECODE, lzwFilter);
        this.addFilter(COSName.LZW_DECODE_ABBREVIATION, lzwFilter);
        this.addFilter(COSName.ASCII_HEX_DECODE, asciiHexFilter);
        this.addFilter(COSName.ASCII_HEX_DECODE_ABBREVIATION, asciiHexFilter);
        this.addFilter(COSName.ASCII85_DECODE, ascii85Filter);
        this.addFilter(COSName.ASCII85_DECODE_ABBREVIATION, ascii85Filter);
        this.addFilter(COSName.RUN_LENGTH_DECODE, runLengthFilter);
        this.addFilter(COSName.RUN_LENGTH_DECODE_ABBREVIATION, runLengthFilter);
        this.addFilter(COSName.CRYPT, cryptFilter);
        this.addFilter(COSName.JPX_DECODE, jpxFilter);
        this.addFilter(COSName.JBIG2_DECODE, jbig2Filter);
    }

    public Collection<Filter> getFilters() {
        return this.filters.values();
    }

    public void addFilter(COSName filterName, Filter filter) {
        this.filters.put(filterName, filter);
    }

    public Filter getFilter(COSName filterName) throws IOException {
        Filter filter = this.filters.get(filterName);
        if (filter == null) {
            throw new IOException("Unknown stream filter:" + filterName);
        }
        return filter;
    }

    public Filter getFilter(String filterName) throws IOException {
        return this.getFilter(COSName.getPDFName(filterName));
    }
}

