/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserBase;
import org.hsqldb.ParserRoutine;
import org.hsqldb.QueryExpression;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSchema;
import org.hsqldb.StatementSchemaDefinition;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;
import org.hsqldb.types.UserTypeModifier;

public class ParserDDL
extends ParserRoutine {
    static final int[] schemaCommands = new int[]{69, 143};
    static final short[] startStatementTokens = new short[]{69, 143, 6, 105};
    static final short[] startStatementTokensSchema = new short[]{69, 143};

    ParserDDL(Session session, Scanner scanner) {
        super(session, scanner);
    }

    @Override
    void reset(Session session, String string) {
        super.reset(session, string);
    }

    StatementSchema compileCreate() {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        this.read();
        switch (this.token.tokenType) {
            case 142: {
                this.read();
                this.readThis(531);
                this.readIfThis(731);
                this.readThis(344);
                bl = true;
                n = 3;
                break;
            }
            case 531: 
            case 813: {
                this.read();
                this.readThis(344);
                bl = true;
                n = 3;
                break;
            }
            case 731: {
                this.read();
                this.readThis(344);
                bl = true;
                n = 4;
                break;
            }
            case 626: {
                this.read();
                this.readThis(344);
                bl = true;
                n = 5;
                break;
            }
            case 814: {
                this.read();
                this.readThis(344);
                bl = true;
                n = 7;
                break;
            }
            case 344: {
                this.read();
                bl = true;
                n = this.database.schemaManager.getDefaultTableType();
                break;
            }
            default: {
                n = 4;
            }
        }
        if (bl) {
            return this.compileCreateTable(n);
        }
        if (this.database.sqlSyntaxOra && this.token.tokenType == 245) {
            this.read();
            this.readThis(781);
            switch (this.token.tokenType) {
                case 139: 
                case 269: 
                case 359: 
                case 544: 
                case 559: 
                case 805: {
                    break;
                }
                default: {
                    throw this.unexpectedToken("OR");
                }
            }
            bl2 = true;
        }
        switch (this.token.tokenType) {
            case 603: {
                return this.compileCreateAlias();
            }
            case 511: {
                return this.compileCreateSequence();
            }
            case 502: {
                return this.compileCreateSchema();
            }
            case 359: {
                return this.compileCreateTrigger(bl2);
            }
            case 373: {
                return this.compileCreateUser();
            }
            case 594: {
                return this.compileCreateRole();
            }
            case 559: {
                return this.compileCreateView(false, bl2);
            }
            case 466: {
                return this.compileCreateDomain();
            }
            case 544: {
                return this.compileCreateType(bl2);
            }
            case 44: {
                return this.compileCreateCharacterSet();
            }
            case 429: {
                return this.compileCreateCollation();
            }
            case 367: {
                this.read();
                this.checkIsThis(697);
                return this.compileCreateIndex(true);
            }
            case 697: {
                return this.compileCreateIndex(false);
            }
            case 602: {
                return this.compileCreateProcedureOrFunction(bl2);
            }
            case 139: 
            case 269: {
                return this.compileCreateProcedureOrFunction(bl2);
            }
            case 805: {
                return this.compileCreateSynonym(bl2);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlter() {
        this.read();
        switch (this.token.tokenType) {
            case 697: {
                return this.compileAlterIndex();
            }
            case 502: {
                this.read();
                HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
                this.readThis(780);
                this.readThis(353);
                return this.compileRenameSchema(hsqlName, 2);
            }
            case 418: {
                this.read();
                this.checkIsSimpleName();
                String string = this.token.tokenString;
                this.checkValidCatalogName(string);
                this.read();
                this.readThis(780);
                this.readThis(353);
                return this.compileRenameObject(this.database.getCatalogName(), 1, false);
            }
            case 511: {
                return this.compileAlterSequence();
            }
            case 344: {
                return this.compileAlterTable();
            }
            case 373: {
                return this.compileAlterUser();
            }
            case 466: {
                return this.compileAlterDomain();
            }
            case 559: {
                return this.compileAlterView();
            }
            case 514: {
                return this.compileAlterSession();
            }
            case 322: {
                return this.compileAlterSpecificRoutine();
            }
            case 595: {
                return this.compileAlterRoutine();
            }
            case 59: {
                this.read();
                Constraint constraint = (Constraint)this.readSchemaObjectName(5);
                if (this.readIfThis(697)) {
                    return this.compileAlterFKIndex(constraint);
                }
                this.readThis(780);
                this.readThis(353);
                return this.compileRenameObject(constraint.getName(), 5, false);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterSpecificRoutine() {
        this.readThis(322);
        this.readThis(595);
        Routine routine = (Routine)this.readSchemaObjectName(24);
        switch (this.token.tokenType) {
            case 780: {
                this.read();
                this.readThis(353);
                return this.compileRenameObject(routine.getSpecificName(), 24, false);
            }
        }
        return this.compileAlterSpecificRoutine(routine);
    }

    Statement compileAlterIndex() {
        this.readThis(697);
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(20, true);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        if (this.token.tokenType == 780) {
            this.read();
            this.readThis(353);
            return this.compileRenameObject(hsqlName, 20, false);
        }
        this.readThis(14);
        Index index = (Index)this.database.schemaManager.findSchemaObject(hsqlName);
        if (index == null) {
            throw Error.error(5501);
        }
        Table table = (Table)this.database.schemaManager.findSchemaObject(index.getName().parent);
        int[] nArray = this.readColumnList(table, true);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{table, nArray, index.getName()};
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(string, 1121, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterFKIndex(Constraint constraint) {
        if (constraint.getConstraintType() != 0) {
            throw Error.error(1501);
        }
        if (constraint.getName().isReservedName()) {
            throw Error.error(4002);
        }
        this.readThis(404);
        Table table = constraint.getRef();
        int[] nArray = this.readColumnList(table, true);
        int[] nArray2 = constraint.getMainColumns();
        int n = ArrayUtil.countCommonElements(nArray2, nArray);
        if (n > 0) {
            throw Error.error(1501);
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{table, nArray, constraint.getName()};
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(string, 1146, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterRoutine() {
        this.readThis(595);
        RoutineSchema routineSchema = (RoutineSchema)this.readSchemaObjectName(18);
        this.readThis(780);
        this.readThis(353);
        return this.compileRenameObject(routineSchema.getName(), routineSchema.getName().type, false);
    }

    Statement compileDrop() {
        HsqlNameManager.HsqlName[] hsqlNameArray;
        SchemaObject schemaObject;
        int n;
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        this.read();
        int n3 = this.token.tokenType;
        switch (n3) {
            case 697: {
                this.read();
                n2 = 1129;
                n = 20;
                bl3 = true;
                break;
            }
            case 409: {
                this.read();
                n2 = 24;
                n = 6;
                bl = true;
                break;
            }
            case 322: {
                this.read();
                switch (this.token.tokenType) {
                    case 139: 
                    case 269: 
                    case 595: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                n2 = 30;
                n = 24;
                bl = true;
                bl3 = true;
                break;
            }
            case 269: {
                this.read();
                n2 = 30;
                n = 17;
                bl = true;
                bl3 = true;
                break;
            }
            case 139: {
                this.read();
                n2 = 30;
                n = 16;
                bl = true;
                bl3 = true;
                break;
            }
            case 502: {
                this.read();
                n2 = 31;
                n = 2;
                bl = true;
                bl3 = true;
                break;
            }
            case 511: {
                this.read();
                n2 = 32;
                n = 7;
                bl = true;
                bl3 = true;
                break;
            }
            case 359: {
                this.read();
                n2 = 36;
                n = 8;
                bl = false;
                bl3 = true;
                break;
            }
            case 373: {
                this.read();
                n2 = 1131;
                n = 11;
                bl = true;
                break;
            }
            case 594: {
                this.read();
                n2 = 29;
                n = 11;
                bl = true;
                break;
            }
            case 466: {
                this.read();
                n2 = 28;
                n = 13;
                bl = true;
                bl3 = true;
                break;
            }
            case 544: {
                this.read();
                n2 = 27;
                n = 12;
                bl = true;
                bl3 = true;
                break;
            }
            case 44: {
                this.read();
                this.readThis(313);
                n2 = 25;
                n = 14;
                bl = false;
                bl3 = true;
                break;
            }
            case 429: {
                this.read();
                n2 = 26;
                n = 15;
                bl = false;
                bl3 = true;
                break;
            }
            case 559: {
                this.read();
                n2 = 39;
                n = 4;
                bl = true;
                bl3 = true;
                break;
            }
            case 344: {
                this.read();
                n2 = 33;
                n = 3;
                bl = true;
                bl3 = true;
                break;
            }
            case 805: {
                this.read();
                n2 = 1148;
                n = 29;
                bl = false;
                bl3 = true;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        if (bl3 && this.token.tokenType == 493) {
            int n4 = this.getPosition();
            this.read();
            if (this.token.tokenType == 122) {
                this.read();
                bl4 = true;
            } else {
                this.rewind(n4);
            }
        }
        this.checkIsIdentifier();
        HsqlNameManager.HsqlName hsqlName = null;
        switch (n3) {
            case 373: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                schemaObject = this.database.getUserManager().get(this.token.tokenString);
                this.read();
                break;
            }
            case 594: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                schemaObject = this.database.getGranteeManager().getRole(this.token.tokenString);
                this.read();
                break;
            }
            case 502: {
                hsqlName = this.readNewSchemaName();
                schemaObject = this.database.schemaManager.findSchema(hsqlName.name);
                break;
            }
            case 344: {
                boolean bl5;
                boolean bl6 = bl5 = this.token.namePrePrefix == null && ("SESSION".equals(this.token.namePrefix) || "MODULE".equals(this.token.namePrefix));
                if (bl5) {
                    hsqlName = this.readNewSchemaObjectName(n, false);
                    if (!bl4 && this.token.tokenType == 493) {
                        this.read();
                        this.readThis(122);
                        bl4 = true;
                    }
                    Object[] objectArray = new Object[]{hsqlName, bl4};
                    return new StatementSession(33, objectArray);
                }
            }
            default: {
                hsqlName = this.readNewSchemaObjectName(n, false);
                hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
                schemaObject = this.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, hsqlName.type);
            }
        }
        if (!bl4 && bl3 && this.token.tokenType == 493) {
            this.read();
            this.readThis(122);
            bl4 = true;
        }
        if (bl) {
            if (this.token.tokenType == 417) {
                bl2 = true;
                this.read();
                if (this.database.sqlSyntaxOra) {
                    this.readIfThis(446);
                }
            } else if (this.token.tokenType == 588) {
                this.read();
            }
        }
        if (schemaObject == null) {
            hsqlNameArray = null;
        } else {
            if (n != 24) {
                hsqlName = schemaObject.getName();
            }
            hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(hsqlName);
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, n, bl2, bl4};
        StatementSchema statementSchema = new StatementSchema(string, n2, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    Statement compileAlterTable() {
        Table table;
        boolean bl = false;
        this.readThis(344);
        if (this.token.tokenType == 493) {
            int n = this.getPosition();
            this.read();
            if (this.token.tokenType == 122) {
                this.read();
                bl = true;
            } else {
                this.rewind(n);
            }
        }
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(3, false);
        if (hsqlName.schema == null) {
            hsqlName.schema = this.session.getCurrentSchemaHsqlName();
        }
        if ((table = bl ? this.database.schemaManager.findUserTable(hsqlName.name, hsqlName.schema.name) : this.database.schemaManager.getUserTable(hsqlName)) != null) {
            hsqlName = table.getName();
            this.checkSchemaUpdateAuthorisation(hsqlName.schema);
        }
        if (bl && this.token.tokenType != 780) {
            throw this.unexpectedToken(493);
        }
        switch (this.token.tokenType) {
            case 780: {
                this.read();
                if (this.database.sqlSyntaxPgs && this.token.tokenType != 353) {
                    if (this.token.tokenType == 53) {
                        this.read();
                    }
                    this.checkIsIdentifier();
                    int n = table.getColumnIndex(this.token.tokenString);
                    ColumnSchema columnSchema = table.getColumn(n);
                    this.read();
                    this.readThis(353);
                    return this.compileAlterColumnRename(table, columnSchema);
                }
                this.readThis(353);
                return this.compileRenameObject(hsqlName, 3, bl);
            }
            case 404: {
                this.read();
                HsqlNameManager.HsqlName hsqlName2 = null;
                Boolean bl2 = Boolean.FALSE;
                if (this.token.tokenType == 59) {
                    this.read();
                    bl2 = this.readIfNotExists();
                    hsqlName2 = this.readNewDependentSchemaObjectName(table.getName(), 5);
                }
                switch (this.token.tokenType) {
                    case 134: {
                        this.read();
                        this.readThis(510);
                        return this.compileAlterTableAddForeignKeyConstraint(table, hsqlName2, bl2);
                    }
                    case 367: {
                        this.read();
                        if (this.database.sqlSyntaxMys && !this.readIfThis(697)) {
                            this.readIfThis(510);
                        }
                        return this.compileAlterTableAddUniqueConstraint(table, hsqlName2, bl2);
                    }
                    case 46: {
                        this.read();
                        return this.compileAlterTableAddCheckConstraint(table, hsqlName2, bl2);
                    }
                    case 268: {
                        this.read();
                        this.readThis(510);
                        return this.compileAlterTableAddPrimaryKey(table, hsqlName2, bl2);
                    }
                    case 260: {
                        if (hsqlName2 != null) {
                            throw this.unexpectedToken();
                        }
                        return this.compileAlterTableAddPeriod(table);
                    }
                    case 341: {
                        if (hsqlName2 != null) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.readThis(383);
                        return this.compileAlterTableAddVersioning(table);
                    }
                    case 53: {
                        if (hsqlName2 != null) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.checkIsSimpleName();
                        return this.compileAlterTableAddColumn(table);
                    }
                    case 510: 
                    case 697: {
                        if (!this.database.sqlSyntaxMys) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.checkIsSimpleName();
                        return this.compileAlterTableAddIndex(table);
                    }
                }
                if (hsqlName2 != null) {
                    throw this.unexpectedToken();
                }
                this.checkIsSimpleName();
                return this.compileAlterTableAddColumn(table);
            }
            case 105: {
                this.read();
                switch (this.token.tokenType) {
                    case 268: {
                        this.read();
                        this.readThis(510);
                        return this.compileAlterTableDropPrimaryKey(table);
                    }
                    case 59: {
                        this.read();
                        return this.compileAlterTableDropConstraint(table);
                    }
                    case 260: {
                        this.read();
                        this.readThis(133);
                        return this.compileAlterTableDropPeriod(table);
                    }
                    case 341: {
                        this.read();
                        this.readThis(383);
                        return this.compileAlterTableDropVersioning(table);
                    }
                    case 53: {
                        this.read();
                        return this.compileAlterTableDropColumn(table);
                    }
                }
                return this.compileAlterTableDropColumn(table);
            }
            case 736: {
                if (!this.database.sqlSyntaxOra) {
                    throw this.unexpectedToken();
                }
                this.read();
                boolean bl3 = this.readIfThis(926);
                int n = table.getColumnIndex(this.token.tokenString);
                ColumnSchema columnSchema = table.getColumn(n);
                this.read();
                Statement statement = this.compileModifyColumn(table, columnSchema, n);
                if (bl3) {
                    this.readThis(911);
                }
                return statement;
            }
            case 6: {
                this.read();
                if (this.token.tokenType == 53) {
                    this.read();
                }
                int n = table.getColumnIndex(this.token.tokenString);
                ColumnSchema columnSchema = table.getColumn(n);
                this.read();
                return this.compileAlterColumn(table, columnSchema, n);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileAlterTableDropConstraint(Table table) {
        boolean bl = false;
        SchemaObject schemaObject = this.readSchemaObjectName(table.getSchemaName(), 5);
        if (this.token.tokenType == 588) {
            this.read();
        } else if (this.token.tokenType == 417) {
            this.read();
            bl = true;
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{schemaObject.getName(), ValuePool.getInt(5), bl, Boolean.FALSE};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        HsqlNameManager.HsqlName hsqlName = ((Constraint)schemaObject).getMainTableName();
        if (hsqlName != null && hsqlName != table.getName()) {
            hsqlNameArray = (HsqlNameManager.HsqlName[])ArrayUtil.toAdjustedArray(hsqlNameArray, hsqlName, hsqlNameArray.length, 1);
        }
        StatementSchema statementSchema = new StatementSchema(string, 1130, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    private Statement compileAlterTableDropPrimaryKey(Table table) {
        boolean bl = false;
        if (this.token.tokenType == 588) {
            this.read();
        } else if (this.token.tokenType == 417) {
            this.read();
            bl = true;
        }
        if (!table.hasPrimaryKey()) {
            throw Error.error(5501);
        }
        String string = this.getLastPart();
        Constraint constraint = table.getPrimaryConstraint();
        Object[] objectArray = new Object[]{constraint.getName(), ValuePool.getInt(5), bl, Boolean.FALSE};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        StatementSchema statementSchema = new StatementSchema(string, 1130, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    StatementSession compileDeclareLocalTableOrNull() {
        Object object;
        StatementSchema statementSchema;
        boolean bl;
        int n = this.getPosition();
        int n2 = 3;
        try {
            this.readThis(93);
            this.readThis(196);
            this.readThis(531);
            this.readThis(344);
        }
        catch (HsqlException hsqlException) {
            this.lastError = hsqlException;
            this.rewind(n);
            return null;
        }
        boolean bl2 = bl = this.token.namePrePrefix == null && (this.token.namePrefix == null || "SESSION".equals(this.token.namePrefix) || "MODULE".equals(this.token.namePrefix));
        if (!bl) {
            throw this.unexpectedToken();
        }
        boolean bl3 = this.readIfNotExists();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(3, false);
        hsqlName.schema = SqlInvariants.SESSION_SCHEMA_HSQLNAME;
        Table table = new Table(this.database, hsqlName, n2);
        if (this.token.tokenType == 14) {
            statementSchema = this.compileCreateTableAsSubqueryDefinition(table, bl3);
        } else {
            statementSchema = this.compileCreateTableBody(table, bl3);
            object = (HsqlArrayList)statementSchema.arguments[1];
            for (int i = 0; i < ((HsqlArrayList)object).size(); ++i) {
                Constraint constraint = (Constraint)((HsqlArrayList)object).get(i);
                if (constraint.getConstraintType() != 0) continue;
                throw this.unexpectedToken("FOREIGN");
            }
        }
        object = new StatementSession(1119, statementSchema.arguments);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatementSchema compileCreateView(boolean bl, boolean bl2) {
        QueryExpression queryExpression;
        this.read();
        Boolean bl3 = Boolean.FALSE;
        if (!bl) {
            bl3 = this.readIfNotExists();
        }
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(4, true);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        this.checkSchemaUpdateAuthorisation(hsqlName.schema);
        HsqlNameManager.HsqlName[] hsqlNameArray = null;
        if (this.token.tokenType == 926) {
            hsqlNameArray = this.readColumnNames(hsqlName);
        }
        this.readThis(14);
        ParserBase.Recorder recorder = this.startRecording();
        try {
            this.isViewDefinition = true;
            queryExpression = this.XreadQueryExpression();
        }
        catch (HsqlException hsqlException) {
            queryExpression = this.XreadJoinedTableAsView();
        }
        finally {
            this.isViewDefinition = false;
        }
        int n = 0;
        if (this.token.tokenType == 390) {
            this.read();
            n = 2;
            if (this.readIfThis(196)) {
                n = 1;
            } else {
                this.readIfThis(37);
            }
            this.readThis(46);
            this.readThis(547);
        }
        View view = new View(this.database, hsqlName, hsqlNameArray, n);
        queryExpression.setView(view);
        queryExpression.resolve(this.session);
        String string = recorder.getSQL();
        view.setStatement(string);
        StatementQuery statementQuery = new StatementQuery(this.session, queryExpression, this.compileContext);
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{view, bl3};
        int n2 = bl ? 1122 : 96;
        HsqlNameManager.HsqlName[] hsqlNameArray2 = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string2, n2, objectArray, statementQuery.readTableNames, hsqlNameArray2);
    }

    StatementSchema compileCreateSequence() {
        this.read();
        Boolean bl = this.readIfNotExists();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(7, false);
        NumberSequence numberSequence = new NumberSequence(hsqlName, Type.SQL_INTEGER);
        this.readSequenceOptions(numberSequence, true, false, false);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{numberSequence, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, 71, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateDomain() {
        Object[] objectArray;
        int n;
        UserTypeModifier userTypeModifier = null;
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(13, false);
        this.readIfThis(14);
        Type type = this.readTypeDefinition(true, false).duplicate();
        Expression expression = null;
        if (this.readIfThis(94)) {
            expression = this.readDefaultClause(type);
        }
        userTypeModifier = new UserTypeModifier(hsqlName, 13, type);
        userTypeModifier.setDefaultClause(expression);
        type.userTypeModifier = userTypeModifier;
        HsqlArrayList<Constraint> hsqlArrayList = new HsqlArrayList<Constraint>();
        this.compileContext.currentDomain = type;
        do {
            n = 0;
            switch (this.token.tokenType) {
                case 46: 
                case 59: {
                    this.readConstraint(type, hsqlArrayList);
                    break;
                }
                default: {
                    n = 1;
                }
            }
        } while (n == 0);
        this.compileContext.currentDomain = null;
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            objectArray = hsqlArrayList.get(n);
            objectArray.prepareDomainCheckConstraint(this.session);
            userTypeModifier.addConstraint((Constraint)objectArray);
        }
        String string = this.getLastPart();
        objectArray = new Object[]{type};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, 23, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateType(boolean bl) {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(12, false);
        this.readThis(14);
        Type type = this.readTypeDefinition(true, false).duplicate();
        this.readIfThis(477);
        type.userTypeModifier = new UserTypeModifier(hsqlName, 12, type);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{type};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, 94, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateCharacterSet() {
        this.read();
        this.readThis(313);
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(14, false);
        this.readIfThis(14);
        this.readThis(141);
        String string = this.token.namePrefix;
        Charset charset = (Charset)this.database.schemaManager.getCharacterSet(this.session, this.token.tokenString, string);
        this.read();
        if (this.token.tokenType == 429) {
            this.read();
            this.readThis(137);
            this.readThis(94);
        }
        Charset charset2 = new Charset(hsqlName, charset.getName());
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{charset2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string2, 11, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateCollation() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(15, false);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        this.readThis(133);
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(14, false);
        this.readThis(137);
        HsqlNameManager.HsqlName hsqlName3 = this.readNewSchemaObjectName(15, false);
        Boolean bl = null;
        if (this.readIfThis(226)) {
            this.readThis(556);
            bl = Boolean.FALSE;
        } else if (this.readIfThis(556)) {
            this.readThis(521);
            bl = Boolean.TRUE;
        }
        String string = hsqlName2.schema == null ? null : hsqlName2.schema.name;
        Charset charset = (Charset)this.database.schemaManager.getCharacterSet(this.session, hsqlName2.name, string);
        if (charset == null) {
            throw Error.error(5501, hsqlName2.getSchemaQualifiedStatementName());
        }
        string = hsqlName3.schema == null ? null : hsqlName3.schema.name;
        Collation collation = this.database.schemaManager.getCollation(this.session, hsqlName3.name, string);
        Collation collation2 = new Collation(hsqlName, collation, charset, bl);
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{collation2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string2, 13, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateAlias() {
        Object[] objectArray;
        Object object;
        String string;
        HsqlNameManager.HsqlName hsqlName = null;
        Routine[] routineArray = null;
        String string2 = null;
        if (!this.session.isProcessingScript()) {
            throw this.unsupportedFeature();
        }
        this.read();
        try {
            string = this.token.tokenString;
            this.read();
            this.readThis(133);
            string2 = this.token.tokenString;
            this.read();
        }
        catch (HsqlException hsqlException) {
            string = null;
        }
        if (string != null) {
            object = this.database.schemaManager.getDefaultSchemaHsqlName();
            hsqlName = this.database.nameManager.newHsqlName((HsqlNameManager.HsqlName)object, string, 16);
            objectArray = Routine.getMethods(string2);
            routineArray = Routine.newRoutines(this.session, (Method[])objectArray);
        }
        object = this.getLastPart();
        objectArray = new Object[]{hsqlName, routineArray};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema((String)object, 1124, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileAlterTableAddIndex(Table table) {
        HsqlNameManager.HsqlName hsqlName = this.readNewDependentSchemaObjectName(table.getName(), 20);
        if (this.database.sqlSyntaxMys) {
            if (this.readIfThis(374) && !this.readIfThis("HASH")) {
                this.readThis("BTREE");
            }
            if (this.readIfThis(633)) {
                hsqlName.comment = this.readQuotedString();
            }
        }
        int[] nArray = this.readColumnList(table, true);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{table, nArray, hsqlName, Boolean.FALSE, null, Boolean.FALSE};
        return new StatementSchema(string, 1125, objectArray, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()});
    }

    StatementSchema compileCreateIndex(boolean bl) {
        this.read();
        Boolean bl2 = this.readIfNotExists();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(20, true);
        if (this.database.sqlSyntaxMys && this.readIfThis(374) && !this.readIfThis("HASH")) {
            this.readThis("BTREE");
        }
        this.readThis(241);
        Table table = this.readTableName();
        HsqlNameManager.HsqlName hsqlName2 = table.getSchemaName();
        hsqlName.setSchemaIfNull(hsqlName2);
        hsqlName.parent = table.getName();
        if (hsqlName.schema != hsqlName2) {
            throw Error.error(5505);
        }
        hsqlName.schema = table.getSchemaName();
        int[] nArray = this.readColumnList(table, true);
        if (this.database.sqlSyntaxMys) {
            if (this.readIfThis(374) && !this.readIfThis("HASH")) {
                this.readThis("BTREE");
            }
            if (this.readIfThis(633)) {
                hsqlName.comment = this.readQuotedString();
            }
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{table, nArray, hsqlName, bl, null, bl2};
        return new StatementSchema(string, 1125, objectArray, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()});
    }

    StatementSchema compileCreateSchema() {
        boolean bl;
        Grantee grantee;
        HsqlNameManager.HsqlName hsqlName = null;
        String string = null;
        HsqlNameManager.HsqlName hsqlName2 = null;
        this.read();
        Boolean bl2 = this.readIfNotExists();
        if (this.token.tokenType != 21) {
            hsqlName = this.readNewSchemaName();
        }
        if (this.token.tokenType == 21) {
            this.read();
            this.checkIsSimpleName();
            string = this.token.tokenString;
            this.read();
            if (hsqlName == null) {
                grantee = this.database.getGranteeManager().get(string);
                if (grantee == null) {
                    throw Error.error(4001, string);
                }
                hsqlName = this.database.nameManager.newHsqlName(grantee.getName().name, this.isDelimitedIdentifier(), 2);
                SqlInvariants.checkSchemaNameNotSystem(this.token.tokenString);
            }
        }
        if ("PUBLIC".equals(string)) {
            throw Error.error(4002, string);
        }
        Grantee grantee2 = grantee = string == null ? this.session.getGrantee() : this.database.getGranteeManager().get(string);
        if (grantee == null) {
            throw Error.error(4001, string);
        }
        if (!this.session.getGrantee().isSchemaCreator()) {
            throw Error.error(2051, this.session.getGrantee().getName().getNameString());
        }
        if (grantee instanceof User && ((User)grantee).isExternalOnly) {
            throw Error.error(2000, this.session.getGrantee().getName().getNameString());
        }
        if (!(!this.database.schemaManager.schemaExists(hsqlName.name) || this.session.isProcessingScript() && "PUBLIC".equals(hsqlName.name) || bl2.booleanValue())) {
            throw Error.error(5504, hsqlName.name);
        }
        if (hsqlName.name.equals("SYSTEM_LOBS")) {
            hsqlName = SqlInvariants.LOBS_SCHEMA_HSQLNAME;
            grantee = hsqlName.owner;
        }
        if (this.readIfThis(94)) {
            this.readThis(44);
            this.readThis(313);
            hsqlName2 = this.readNewSchemaObjectName(14, false);
        }
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, grantee, bl2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        StatementSchema statementSchema = new StatementSchema(string2, 68, objectArray, null, hsqlNameArray);
        statementSchema.setSchemaHsqlName(hsqlName);
        HsqlArrayList<StatementSchema> hsqlArrayList = new HsqlArrayList<StatementSchema>(128);
        hsqlArrayList.add(statementSchema);
        this.getCompiledStatementBody(hsqlArrayList);
        StatementSchema[] statementSchemaArray = new StatementSchema[hsqlArrayList.size()];
        hsqlArrayList.toArray(statementSchemaArray);
        do {
            bl = false;
            for (int i = 0; i < statementSchemaArray.length - 1; ++i) {
                if (statementSchemaArray[i].order <= statementSchemaArray[i + 1].order) continue;
                StatementSchema statementSchema2 = statementSchemaArray[i + 1];
                statementSchemaArray[i + 1] = statementSchemaArray[i];
                statementSchemaArray[i] = statementSchema2;
                bl = true;
            }
        } while (bl);
        return new StatementSchemaDefinition(statementSchemaArray);
    }

    void getCompiledStatementBody(List<StatementSchema> list) {
        boolean bl = false;
        while (!bl) {
            StatementSchema statementSchema = null;
            int n = this.getPosition();
            block0 : switch (this.token.tokenType) {
                case 69: {
                    this.read();
                    switch (this.token.tokenType) {
                        case 367: 
                        case 373: 
                        case 502: {
                            throw this.unexpectedToken();
                        }
                        case 697: {
                            int n2 = 1125;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                        case 511: {
                            statementSchema = this.compileCreateSequence();
                            statementSchema.sql = this.getLastPart(n);
                            break block0;
                        }
                        case 594: {
                            statementSchema = this.compileCreateRole();
                            statementSchema.sql = this.getLastPart(n);
                            break block0;
                        }
                        case 466: {
                            int n2 = 23;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                        case 544: {
                            statementSchema = this.compileCreateType(false);
                            statementSchema.sql = this.getLastPart(n);
                            break block0;
                        }
                        case 44: {
                            statementSchema = this.compileCreateCharacterSet();
                            statementSchema.sql = this.getLastPart(n);
                            break block0;
                        }
                        case 409: {
                            throw this.unexpectedToken();
                        }
                        case 142: 
                        case 344: 
                        case 531: 
                        case 626: 
                        case 731: 
                        case 813: 
                        case 814: {
                            int n2 = 87;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                        case 359: {
                            int n2 = 90;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                        case 559: {
                            int n2 = 96;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                        case 139: 
                        case 269: {
                            int n2 = 69;
                            String string = this.getStatementForRoutine(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2);
                            break block0;
                        }
                    }
                    throw this.unexpectedToken();
                }
                case 143: {
                    statementSchema = this.compileGrantOrRevoke();
                    statementSchema.sql = this.getLastPart(n);
                    break;
                }
                case 932: {
                    this.read();
                    bl = true;
                    break;
                }
                case 1014: {
                    bl = true;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (statementSchema == null) continue;
            statementSchema.isSchemaDefinition = true;
            list.add(statementSchema);
        }
    }

    StatementSchema compileCreateRole() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewUserIdentifier();
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, 65, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateUser() {
        Boolean bl = Boolean.FALSE;
        Boolean bl2 = Boolean.FALSE;
        Grantee grantee = this.session.getGrantee();
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewUserIdentifier();
        this.readThis(758);
        if (this.readIfThis(674)) {
            bl2 = Boolean.TRUE;
        }
        String string = this.readPassword();
        if (this.token.tokenType == 405) {
            this.read();
            bl = Boolean.TRUE;
        }
        this.checkDatabaseUpdateAuthorisation();
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, string, grantee, bl, bl2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string2, 1126, objectArray, null, hsqlNameArray);
    }

    HsqlNameManager.HsqlName readNewUserIdentifier() {
        this.checkIsSimpleName();
        String string = this.token.tokenString;
        boolean bl = this.isDelimitedIdentifier();
        if (string.equalsIgnoreCase("SA")) {
            string = "SA";
            bl = false;
        }
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(string, bl, 11);
        this.read();
        return hsqlName;
    }

    String readPassword() {
        String string = this.token.tokenString;
        if (this.isUndelimitedSimpleName() || this.isDelimitedSimpleName()) {
            this.read();
        } else {
            this.readQuotedString();
        }
        return string;
    }

    StatementSchema compileCreateSynonym(boolean bl) {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(29, true);
        this.readThis(133);
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(29, true);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, hsqlName2};
        return new StatementSchema(string, 1147, objectArray, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName()});
    }

    Statement compileRenameObject(HsqlNameManager.HsqlName hsqlName, int n, boolean bl) {
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(n, true);
        String string = this.getLastPart();
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                this.checkSchemaUpdateAuthorisation(this.session, hsqlName);
                break;
            }
            default: {
                hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
                this.checkSchemaUpdateAuthorisation(this.session, hsqlName.schema);
            }
        }
        Object[] objectArray = new Object[]{hsqlName, hsqlName2, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(string, 1152, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddUniqueConstraint(Table table, HsqlNameManager.HsqlName hsqlName, Boolean bl) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        int[] nArray = this.readColumnList(table, false);
        HsqlNameManager.HsqlName hsqlName2 = this.session.database.nameManager.newConstraintIndexName(table.getName(), hsqlName, this.session.database.sqlSysIndexNames);
        Index index = table.createIndexStructure(hsqlName2, nArray, null, null, false, true, true, false);
        Constraint constraint = new Constraint(hsqlName, table, index, 2);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1134, table, constraint, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddForeignKeyConstraint(Table table, HsqlNameManager.HsqlName hsqlName, Boolean bl) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("FK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet<String> orderedHashSet = this.readColumnNames(false);
        Constraint constraint = this.readFKReferences(table, hsqlName, orderedHashSet);
        HsqlNameManager.HsqlName hsqlName2 = constraint.getMainTableName();
        constraint.core.mainTable = this.database.schemaManager.getUserTable(hsqlName2);
        constraint.setColumnsIndexes(table);
        if (constraint.core.mainCols.length != constraint.core.refCols.length) {
            throw Error.error(5593);
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1134, table, constraint, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        if (hsqlName2 != table.getName()) {
            hsqlNameArray = (HsqlNameManager.HsqlName[])ArrayUtil.toAdjustedArray(hsqlNameArray, hsqlName2, hsqlNameArray.length, 1);
        }
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddCheckConstraint(Table table, HsqlNameManager.HsqlName hsqlName, Boolean bl) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        Constraint constraint = new Constraint(hsqlName, null, 3);
        this.readCheckConstraintCondition(constraint);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1134, table, constraint, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddColumn(Table table) {
        int n = table.getColumnCount();
        HsqlArrayList<Constraint> hsqlArrayList = new HsqlArrayList<Constraint>();
        Constraint constraint = new Constraint(null, null, 5);
        Boolean bl = this.readIfNotExists();
        hsqlArrayList.add(constraint);
        this.checkIsSimpleName();
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        ColumnSchema columnSchema = this.readColumnDefinitionOrNull(table, hsqlName, hsqlArrayList);
        if (columnSchema == null) {
            throw Error.error(5000);
        }
        if (this.token.tokenType == 413) {
            this.read();
            n = table.getColumnIndex(this.token.tokenString);
            this.read();
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1133, table, columnSchema, n, hsqlArrayList, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddPrimaryKey(Table table, HsqlNameManager.HsqlName hsqlName, Boolean bl) {
        if (hsqlName == null) {
            hsqlName = this.session.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet<String> orderedHashSet = this.readColumnNames(false);
        Constraint constraint = new Constraint(hsqlName, orderedHashSet, 4);
        constraint.setColumnsIndexes(table);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1134, table, constraint, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableDropColumn(Table table) {
        boolean bl = false;
        this.checkIsSimpleName();
        String string = this.token.tokenString;
        this.read();
        if (this.token.tokenType == 588) {
            this.read();
        } else if (this.token.tokenType == 417) {
            this.read();
            bl = true;
        }
        int n = table.getColumnIndex(string);
        if (table.getColumnCount() == 1) {
            throw Error.error(5591);
        }
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{table.getColumn(n).getName(), ValuePool.getInt(9), bl, Boolean.FALSE};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string2, 1128, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterColumn(Table table, ColumnSchema columnSchema, int n) {
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        int n2 = this.getPosition();
        switch (this.token.tokenType) {
            case 780: {
                this.read();
                this.readThis(353);
                return this.compileAlterColumnRename(table, columnSchema);
            }
            case 105: {
                this.read();
                if (this.token.tokenType == 94) {
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1141, table, columnSchema, n};
                    return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
                }
                if (this.token.tokenType == 476) {
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1142, table, columnSchema, n};
                    return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
                }
                if (this.token.tokenType == 488 || this.token.tokenType == 152) {
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1143, table, columnSchema, n};
                    return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
                }
                if (this.token.tokenType == 229) {
                    this.read();
                    this.readThis(232);
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1139, table, columnSchema, Boolean.TRUE};
                    return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
                }
                throw this.unexpectedToken();
            }
            case 313: {
                this.read();
                switch (this.token.tokenType) {
                    case 451: {
                        this.read();
                        this.readThis(544);
                        return this.compileAlterColumnDataType(table, columnSchema);
                    }
                    case 94: {
                        this.read();
                        return this.compileAlterColumnDefault(table, columnSchema, n);
                    }
                    case 229: {
                        this.read();
                        this.readThis(232);
                        return this.compileAlterColumnSetNullability(table, columnSchema, false);
                    }
                    case 232: {
                        this.read();
                        return this.compileAlterColumnSetNullability(table, columnSchema, true);
                    }
                    case 488: {
                        return this.compileAlterColumnAddSequence(table, columnSchema, n);
                    }
                }
                this.rewind(n2);
                this.read();
                break;
            }
            case 544: {
                if (!this.database.sqlSyntaxPgs) break;
                this.read();
                return this.compileAlterColumnDataType(table, columnSchema);
            }
            case 488: {
                return this.compileAlterColumnAddSequence(table, columnSchema, n);
            }
        }
        if (this.token.tokenType == 313 || this.token.tokenType == 587) {
            if (!columnSchema.isIdentity()) {
                throw Error.error(5535);
            }
            return this.compileAlterColumnSequenceOptions(table, columnSchema, n);
        }
        return this.compileAlterColumnDataTypeIdentity(table, columnSchema);
    }

    Statement compileModifyColumn(Table table, ColumnSchema columnSchema, int n) {
        Object[] objectArray;
        Statement[] statementArray;
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        int n2 = this.getPosition();
        Statement statement = null;
        StatementSchema statementSchema = null;
        Statement statement2 = null;
        StatementSchema statementSchema2 = null;
        Statement statement3 = null;
        try {
            statement3 = this.compileAlterColumnDataType(table, columnSchema);
            statement3.isLogged = false;
        }
        catch (HsqlException hsqlException) {
            this.rewind(n2);
        }
        switch (this.token.tokenType) {
            case 105: {
                this.read();
                if (this.token.tokenType == 488 || this.token.tokenType == 152) {
                    this.read();
                    statementArray = this.getLastPart();
                    objectArray = new Object[]{1143, table, columnSchema, n};
                    statementSchema = new StatementSchema((String)statementArray, 7, objectArray, null, hsqlNameArray);
                    statementSchema.isLogged = false;
                    break;
                }
                throw this.unexpectedToken();
            }
            case 94: {
                this.read();
                statement2 = this.compileAlterColumnDefault(table, columnSchema, n);
                statement2.isLogged = false;
                break;
            }
            case 488: {
                statementSchema2 = this.compileAlterColumnAddSequence(table, columnSchema, n);
                statementSchema2.isLogged = false;
                break;
            }
        }
        switch (this.token.tokenType) {
            case 229: {
                this.read();
                this.readThis(232);
                statement = this.compileAlterColumnSetNullability(table, columnSchema, false);
                statement.isLogged = false;
                break;
            }
            case 232: {
                this.read();
                statement = this.compileAlterColumnSetNullability(table, columnSchema, true);
                statement.isLogged = false;
                break;
            }
        }
        statementArray = new Statement[]{statement3, statementSchema, statementSchema2, statement2, statement};
        objectArray = this.getLastPart();
        Object[] objectArray2 = new Object[]{1145, table, columnSchema, n, statementArray};
        statement2 = new StatementSchema((String)objectArray, 7, objectArray2, null, hsqlNameArray);
        return statement2;
    }

    private Statement compileAlterColumnDataTypeIdentity(Table table, ColumnSchema columnSchema) {
        if (columnSchema.isGenerated()) {
            throw Error.error(5561);
        }
        NumberSequence numberSequence = columnSchema.getIdentitySequence();
        Type type = columnSchema.getDataType();
        if (this.token.tokenType == 152) {
            this.read();
            if (!type.isIntegralType()) {
                throw Error.error(5561);
            }
            if (numberSequence == null) {
                numberSequence = new NumberSequence(null, type);
            }
        } else {
            type = this.readTypeDefinition(true, true);
            switch (this.token.tokenType) {
                case 152: {
                    if (!type.isIntegralType()) {
                        throw Error.error(5561);
                    }
                    this.read();
                    if (numberSequence != null) break;
                    numberSequence = new NumberSequence(null, type);
                    break;
                }
                case 488: {
                    numberSequence = this.readSequence(table, columnSchema, true);
                    break;
                }
                default: {
                    numberSequence = null;
                }
            }
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1144, table, columnSchema, type, numberSequence};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    private Statement compileAlterColumnDataType(Table table, ColumnSchema columnSchema) {
        if (columnSchema.isGenerated()) {
            throw Error.error(5561);
        }
        Type type = this.readTypeDefinition(true, true);
        if (columnSchema.isIdentity() && !type.isIntegralType()) {
            throw Error.error(5561);
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1136, table, columnSchema, type};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    private Statement compileAlterColumnSetNullability(Table table, ColumnSchema columnSchema, boolean bl) {
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1139, table, columnSchema, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    private Statement compileAlterColumnDefault(Table table, ColumnSchema columnSchema, int n) {
        Type type = columnSchema.getDataType();
        Expression expression = this.readDefaultClause(type);
        String string = this.getLastPart();
        int n2 = 1140;
        Object object = expression;
        if (expression.opType == 12) {
            n2 = 1137;
            object = ((ExpressionColumn)expression).sequence;
        }
        Object[] objectArray = new Object[]{n2, table, columnSchema, n, object};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterSequence() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.namePrefix);
        NumberSequence numberSequence = this.database.schemaManager.getSequence(this.token.tokenString, hsqlName.name, true);
        this.read();
        if (this.token.tokenType == 780) {
            this.read();
            this.readThis(353);
            return this.compileRenameObject(numberSequence.getName(), 7, false);
        }
        this.checkSchemaUpdateAuthorisation(this.session, numberSequence.getName().schema);
        NumberSequence numberSequence2 = numberSequence.duplicate();
        this.readSequenceOptions(numberSequence2, false, true, false);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{numberSequence, numberSequence2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(string, 5, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileAlterColumnAddSequence(Table table, ColumnSchema columnSchema, int n) {
        if (!columnSchema.getDataType().isIntegralType()) {
            throw Error.error(5525);
        }
        if (columnSchema.isIdentity()) {
            throw Error.error(5525);
        }
        NumberSequence numberSequence = this.readSequence(table, columnSchema, false);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1137, table, columnSchema, n, numberSequence};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    NumberSequence readSequence(Table table, ColumnSchema columnSchema, boolean bl) {
        this.readThis(488);
        NumberSequence numberSequence = new NumberSequence(null, columnSchema.getDataType());
        boolean bl2 = false;
        if (this.token.tokenType == 33) {
            this.read();
            this.readThis(94);
        } else {
            this.readThis(407);
            bl2 = true;
        }
        this.readThis(14);
        if (!bl && this.token.tokenType == 511) {
            if (bl2) {
                throw this.unexpectedToken();
            }
            this.read();
            if (this.token.namePrefix != null && !this.token.namePrefix.equals(table.getSchemaName().name)) {
                throw this.unexpectedToken(this.token.namePrefix);
            }
            numberSequence = this.database.schemaManager.getSequence(this.token.tokenString, table.getSchemaName().name, true);
            this.read();
        } else {
            this.readThis(152);
            numberSequence.setAlways(bl2);
            if (this.token.tokenType == 926) {
                this.read();
                this.readSequenceOptions(numberSequence, false, false, false);
                this.readThis(911);
            }
            numberSequence.checkValues();
        }
        return numberSequence;
    }

    StatementSchema compileAlterColumnSequenceOptions(Table table, ColumnSchema columnSchema, int n) {
        boolean bl;
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        NumberSequence numberSequence = columnSchema.getIdentitySequence().duplicate();
        do {
            bl = false;
            block0 : switch (this.token.tokenType) {
                case 587: {
                    long l;
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.readIfThis(390)) {
                        l = this.readBigint();
                        numberSequence.setCurrentValueNoCheck(l);
                        break;
                    }
                    numberSequence.reset();
                    break;
                }
                case 313: {
                    long l;
                    this.read();
                    switch (this.token.tokenType) {
                        case 499: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            this.readThis(33);
                            l = this.readBigint();
                            numberSequence.setIncrement(l);
                            break block0;
                        }
                        case 226: {
                            this.read();
                            if (this.token.tokenType == 522) {
                                numberSequence.setDefaultMaxValue();
                            } else if (this.token.tokenType == 527) {
                                numberSequence.setDefaultMinValue();
                            } else if (this.token.tokenType == 86) {
                                numberSequence.setCycle(false);
                            } else {
                                throw this.unexpectedToken();
                            }
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            break block0;
                        }
                        case 522: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            l = this.readBigint();
                            numberSequence.setMaxValueNoCheck(l);
                            break block0;
                        }
                        case 527: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            l = this.readBigint();
                            numberSequence.setMinValueNoCheck(l);
                            break block0;
                        }
                        case 86: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            numberSequence.setCycle(true);
                            break block0;
                        }
                    }
                    throw this.unexpectedToken();
                }
                default: {
                    bl = true;
                }
            }
        } while (!bl);
        numberSequence.checkValues();
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1137, table, columnSchema, n, numberSequence};
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    private Statement compileAlterColumnRename(Table table, ColumnSchema columnSchema) {
        this.checkIsSimpleName();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(9, true);
        if (table.findColumn(hsqlName.name) > -1) {
            throw Error.error(5504, hsqlName.name);
        }
        this.database.schemaManager.checkColumnIsReferenced(table.getName(), columnSchema.getName());
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{columnSchema.getName(), hsqlName, Boolean.FALSE};
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(string, 1152, objectArray, null, hsqlNameArray);
    }

    Statement compileRenameSchema(HsqlNameManager.HsqlName hsqlName, int n) {
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(n, true);
        String string = this.getLastPart();
        this.checkSchemaUpdateAuthorisation(this.session, hsqlName);
        Object[] objectArray = new Object[]{hsqlName, hsqlName2, Boolean.FALSE};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(string, 1153, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterUser() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewUserIdentifier();
        User user = this.database.getUserManager().get(hsqlName.name);
        if (hsqlName.name.equals("PUBLIC")) {
            throw Error.error(5503);
        }
        if (hsqlName.name.equals("_SYSTEM")) {
            throw Error.error(5503);
        }
        this.readThis(313);
        switch (this.token.tokenType) {
            case 196: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{user, bl};
                return new StatementCommand(1091, objectArray);
            }
            case 758: {
                this.read();
                boolean bl = false;
                if (this.readIfThis(674)) {
                    bl = Boolean.TRUE;
                }
                String string = this.readPassword();
                Object[] objectArray = new Object[]{user, string, bl};
                StatementCommand statementCommand = new StatementCommand(1093, objectArray);
                String string2 = user.getSetUserPasswordDigestSQL(string, bl);
                statementCommand.setSQL(string2);
                return statementCommand;
            }
            case 156: {
                this.read();
                this.readThis(502);
                HsqlNameManager.HsqlName hsqlName2 = this.token.tokenType == 94 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] objectArray = new Object[]{user, hsqlName2};
                return new StatementCommand(1092, objectArray);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterDomain() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(hsqlName);
        Type type = this.database.schemaManager.getDomain(this.token.tokenString, hsqlName.name, true);
        this.read();
        switch (this.token.tokenType) {
            case 780: {
                this.read();
                this.readThis(353);
                return this.compileRenameObject(type.getName(), 13, false);
            }
            case 105: {
                this.read();
                if (this.token.tokenType == 94) {
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1132, type};
                    HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(type.getName());
                    return new StatementSchema(string, 3, objectArray, null, hsqlNameArray);
                }
                if (this.token.tokenType == 59) {
                    this.read();
                    this.checkIsSchemaObjectName();
                    HsqlNameManager.HsqlName hsqlName2 = this.database.schemaManager.getSchemaObjectName(type.getSchemaName(), this.token.tokenString, 5, true);
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1130, type, hsqlName2};
                    HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(type.getName());
                    return new StatementSchema(string, 3, objectArray, null, hsqlNameArray);
                }
                throw this.unexpectedToken();
            }
            case 313: {
                this.read();
                this.readThis(94);
                Expression expression = this.readDefaultClause(type);
                String string = this.getLastPart();
                Object[] objectArray = new Object[]{1135, type, expression};
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(type.getName());
                return new StatementSchema(string, 3, objectArray, null, hsqlNameArray);
            }
            case 404: {
                this.read();
                if (this.token.tokenType != 59 && this.token.tokenType != 46) break;
                HsqlArrayList<Constraint> hsqlArrayList = new HsqlArrayList<Constraint>();
                this.compileContext.currentDomain = type;
                this.readConstraint(type, hsqlArrayList);
                this.compileContext.currentDomain = null;
                Constraint constraint = hsqlArrayList.get(0);
                constraint.prepareDomainCheckConstraint(this.session);
                String string = this.getLastPart();
                Object[] objectArray = new Object[]{1134, type, constraint};
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(type.getName());
                return new StatementSchema(string, 3, objectArray, null, hsqlNameArray);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileAlterView() {
        int n = this.getPosition();
        this.read();
        String string = this.token.tokenString;
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(hsqlName);
        Table table = this.database.schemaManager.getUserTable(string, hsqlName.name);
        this.read();
        switch (this.token.tokenType) {
            case 780: {
                this.read();
                this.readThis(353);
                return this.compileRenameObject(table.getName(), 4, false);
            }
            case 14: {
                this.rewind(n);
                return this.compileCreateView(true, false);
            }
        }
        throw this.unexpectedToken();
    }

    private boolean isGrantToken() {
        switch (this.token.tokenType) {
            case 4: 
            case 96: 
            case 121: 
            case 160: 
            case 277: 
            case 310: 
            case 371: 
            case 551: {
                return true;
            }
        }
        return false;
    }

    StatementSchema compileGrantOrRevoke() {
        boolean bl = this.token.tokenType == 143;
        this.read();
        if (this.isGrantToken() || !bl && (this.token.tokenType == 143 || this.token.tokenType == 492)) {
            return this.compileRightGrantOrRevoke(bl);
        }
        return this.compileRoleGrantOrRevoke(bl);
    }

    private StatementSchema compileRightGrantOrRevoke(boolean bl) {
        Object object;
        HsqlNameManager.HsqlName[] hsqlNameArray;
        Object[] objectArray;
        int n;
        int n2;
        OrderedHashSet<String> orderedHashSet = new OrderedHashSet<String>();
        Grantee grantee = null;
        Right right = null;
        HsqlNameManager.HsqlName hsqlName = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        if (!bl) {
            if (this.token.tokenType == 143) {
                this.read();
                this.readThis(547);
                this.readThis(133);
                bl6 = true;
            } else if (this.token.tokenType == 492) {
                throw this.unsupportedFeature();
            }
        }
        if (this.token.tokenType == 4) {
            this.read();
            if (this.token.tokenType == 579) {
                this.read();
            }
            right = Right.fullRights;
            bl5 = true;
        } else {
            right = new Right();
            n2 = 1;
            block22: while (n2 != 0) {
                this.checkIsUndelimitedIdentifier();
                int n3 = GranteeManager.getCheckSingleRight(this.token.tokenString);
                n = this.token.tokenType;
                objectArray = null;
                this.read();
                switch (n) {
                    case 160: 
                    case 277: 
                    case 310: 
                    case 371: {
                        if (this.token.tokenType == 926) {
                            objectArray = this.readColumnNames(false);
                        }
                    }
                    case 96: {
                        right.set(n3, (OrderedHashSet<String>)objectArray);
                        bl2 = true;
                        if (!bl || n == 277) break;
                        hsqlNameArray = this.startRecording();
                        object = this.XreadFilterExpressionOrNull();
                        if (object == null) break;
                        String string = hsqlNameArray.getSQL();
                        right.setFilterExpression(n3, (Expression)object, string);
                        bl7 = true;
                        break;
                    }
                    case 359: {
                        right.set(n3, null);
                        bl2 = true;
                        break;
                    }
                    case 551: {
                        if (bl2) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        bl3 = true;
                        n2 = 0;
                        continue block22;
                    }
                    case 121: {
                        if (bl2) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        bl4 = true;
                        n2 = 0;
                        continue block22;
                    }
                }
                if (this.token.tokenType != 913) break;
                this.read();
            }
        }
        this.readThis(241);
        n2 = 0;
        switch (this.token.tokenType) {
            case 631: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (!this.isSimpleName() || !this.isDelimitedIdentifier()) {
                    throw Error.error(5569);
                }
                n2 = 16;
                break;
            }
            case 322: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                switch (this.token.tokenType) {
                    case 139: 
                    case 269: 
                    case 595: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                n2 = 24;
                break;
            }
            case 139: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 16;
                break;
            }
            case 269: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 17;
                break;
            }
            case 595: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 18;
                break;
            }
            case 544: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 12;
                break;
            }
            case 466: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 13;
                break;
            }
            case 511: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 7;
                break;
            }
            case 44: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                this.readThis(313);
                n2 = 14;
                break;
            }
            case 4: {
                this.read();
                if (this.readIfThis("SEQUENCES")) {
                    if (!bl3 && !bl5) {
                        throw this.unexpectedToken("SEQUENCES");
                    }
                    right = new Right();
                    right.set(16, null);
                } else if (this.readIfThis("ROUTINES")) {
                    if (!bl4 && !bl5) {
                        throw this.unexpectedToken("ROUTINES");
                    }
                    right = new Right();
                    right.set(32, null);
                } else {
                    if (!bl2 && !bl5) {
                        throw this.unexpectedToken();
                    }
                    this.readThis("TABLES");
                }
                this.readThis(154);
                this.readThis(502);
                n2 = 2;
                break;
            }
            default: {
                if (!bl2 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.readIfThis(344);
                n2 = 3;
            }
        }
        hsqlName = this.readNewSchemaObjectName(n2, false);
        if (bl) {
            if (n2 == 3 && !bl7) {
                ParserBase.Recorder recorder = this.startRecording();
                Expression expression = this.XreadFilterExpressionOrNull();
                if (expression != null) {
                    objectArray = recorder.getSQL();
                    right.setFilterExpression(expression, (String)objectArray);
                }
            }
            this.readThis(353);
        } else {
            this.readThis(137);
        }
        while (true) {
            this.checkIsSimpleName();
            orderedHashSet.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 913) break;
            this.read();
        }
        if (bl) {
            if (this.token.tokenType == 390) {
                this.read();
                this.readThis(143);
                this.readThis(547);
                bl6 = true;
            }
            if (this.token.tokenType == 491) {
                this.read();
                this.readThis(33);
                if (this.token.tokenType == 84) {
                    this.read();
                } else {
                    this.readThis(78);
                    if (this.session.getRole() == null) {
                        throw Error.error(2200);
                    }
                    grantee = this.session.getRole();
                }
            }
        } else if (this.token.tokenType == 417) {
            bl8 = true;
            this.read();
        } else {
            this.readThis(588);
        }
        String string = this.getLastPart();
        n = bl ? 53 : 63;
        objectArray = new Object[]{orderedHashSet, hsqlName, right, grantee, bl8, bl6};
        hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        object = new StatementSchema(string, n, objectArray, null, hsqlNameArray);
        return object;
    }

    private StatementSchema compileRoleGrantOrRevoke(boolean bl) {
        Grantee grantee = this.session.getGrantee();
        OrderedHashSet<String> orderedHashSet = new OrderedHashSet<String>();
        OrderedHashSet<String> orderedHashSet2 = new OrderedHashSet<String>();
        boolean bl2 = false;
        if (!bl && this.token.tokenType == 405) {
            throw this.unsupportedFeature();
        }
        while (true) {
            this.checkIsSimpleName();
            orderedHashSet.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 913) break;
            this.read();
        }
        if (bl) {
            this.readThis(353);
        } else {
            this.readThis(137);
        }
        while (true) {
            this.checkIsSimpleName();
            orderedHashSet2.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 913) break;
            this.read();
        }
        if (bl && this.token.tokenType == 390) {
            throw this.unsupportedFeature();
        }
        if (this.token.tokenType == 491) {
            this.read();
            this.readThis(33);
            if (this.token.tokenType == 84) {
                this.read();
            } else {
                this.readThis(78);
                if (this.session.getRole() == null) {
                    throw Error.error(2200);
                }
                grantee = this.session.getRole();
            }
        }
        if (!bl) {
            if (this.token.tokenType == 417) {
                bl2 = true;
                this.read();
            } else {
                this.readThis(588);
            }
        }
        String string = this.getLastPart();
        int n = bl ? 54 : 64;
        Object[] objectArray = new Object[]{orderedHashSet2, orderedHashSet, grantee, bl2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        StatementSchema statementSchema = new StatementSchema(string, n, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    void checkDatabaseUpdateAuthorisation() {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
    }

    void checkSchemaUpdateAuthorisation(Session session, HsqlNameManager.HsqlName hsqlName) {
        if (session.isProcessingLog()) {
            return;
        }
        if (SqlInvariants.isSystemSchemaName(hsqlName.name)) {
            throw Error.error(5503);
        }
        if (session.parser.isSchemaDefinition) {
            if (hsqlName == session.getCurrentSchemaHsqlName()) {
                return;
            }
            throw Error.error(5505, hsqlName.name);
        }
        session.getGrantee().checkSchemaUpdateOrGrantRights(hsqlName);
        session.checkDDLWrite();
    }

    StatementSchema compileComment() {
        int n;
        this.readThis(633);
        this.readThis(241);
        switch (this.token.tokenType) {
            case 511: {
                n = 7;
                break;
            }
            case 359: {
                n = 8;
                break;
            }
            case 595: {
                n = 18;
                break;
            }
            case 344: {
                n = 3;
                break;
            }
            case 53: {
                n = 9;
                break;
            }
            case 559: {
                n = 4;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.read();
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.token.isDelimitedIdentifier, n);
        if (n == 9) {
            if (this.token.namePrefix == null) {
                throw Error.error(5501);
            }
            hsqlName.parent = this.database.nameManager.newHsqlName(this.token.namePrefix, this.token.isDelimitedPrefix, 3);
            hsqlName.parent.schema = this.token.namePrePrefix == null ? this.session.getCurrentSchemaHsqlName() : this.database.nameManager.newHsqlName(this.token.namePrePrefix, this.token.isDelimitedPrePrefix, 2);
        } else {
            hsqlName.schema = this.token.namePrefix == null ? this.session.getCurrentSchemaHsqlName() : this.database.nameManager.newHsqlName(this.token.namePrefix, this.token.isDelimitedPrefix, 2);
        }
        this.read();
        this.readThis(167);
        String string = this.readQuotedString();
        Object[] objectArray = new Object[]{hsqlName, string};
        return new StatementSchema(null, 1123, objectArray, null, null);
    }

    Statement compileAlterSession() {
        this.read();
        this.session.checkAdmin();
        if (this.token.tokenType == 782) {
            this.read();
            int n = this.token.tokenType;
            switch (this.token.tokenType) {
                case 4: {
                    this.read();
                    break;
                }
                case 291: {
                    this.read();
                    this.readThis(516);
                    break;
                }
                case 344: {
                    this.read();
                    this.readThis(451);
                    break;
                }
                default: {
                    throw this.unexpectedTokenRequire("ALL,RESULT,TABLE");
                }
            }
            Object[] objectArray = new Object[]{this.session.getId(), n};
            return new StatementCommand(1120, objectArray);
        }
        long l = this.readBigint();
        Session session = this.database.sessionManager.getSession(l);
        if (session == null) {
            throw Error.error(4500);
        }
        int n = this.token.tokenType;
        switch (this.token.tokenType) {
            case 49: {
                this.read();
                break;
            }
            case 288: {
                this.read();
                break;
            }
            case 112: {
                this.read();
                this.readThis(524);
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] objectArray = new Object[]{l, n};
        return new StatementCommand(1120, objectArray);
    }

    boolean processTrueOrFalse() {
        if (this.token.namePrefix != null) {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 362) {
            this.read();
            return true;
        }
        if (this.token.tokenType == 127) {
            this.read();
            return false;
        }
        throw this.unexpectedToken();
    }

    Boolean processTrueOrFalseObject() {
        return this.processTrueOrFalse();
    }
}

